/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.conditions;

import java.util.Collection;
import java.util.function.Predicate;
import org.assertj.core.api.Condition;

public final class Conditions {
    public static final Condition<Boolean> TRUE = new Condition(value -> value, "Should be true.", new Object[0]);
    public static final Condition<Boolean> FALSE = new Condition(value -> value == false, "Should be false.", new Object[0]);

    private Conditions() {
    }

    public static <T> Condition<T> condition(Predicate<T> predicate) {
        return new Condition(predicate, "Generic condition. See predicate for condition details.", new Object[0]);
    }

    public static <T> Condition<T> equalityCondition(T value) {
        return new Condition(v -> v.equals(value), "Should be equal to " + String.valueOf(value), new Object[0]);
    }

    public static <T extends Comparable<T>> Condition<T> greaterThan(T value) {
        return new Condition(v -> v.compareTo(value) > 0, "Should be greater than " + String.valueOf(value), new Object[0]);
    }

    public static <T extends Comparable<T>> Condition<T> greaterThanOrEqualTo(T value) {
        return new Condition(v -> v.compareTo(value) >= 0, "Should be greater than or equal to " + String.valueOf(value), new Object[0]);
    }

    public static <T extends Collection<?>> Condition<T> sizeCondition(int expectedSize) {
        return new Condition(v -> v.size() == expectedSize, "Size should be equal to " + expectedSize, new Object[0]);
    }
}

