/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DoubleLatch {
    private static final long FIVE_MINUTES = TimeUnit.MINUTES.toMillis(5L);
    private final CountDownLatch startSignal;
    private final CountDownLatch finishSignal;
    private final boolean awaitUninterruptibly;

    public DoubleLatch() {
        this(1);
    }

    public DoubleLatch(int numberOfContestants) {
        this(numberOfContestants, false);
    }

    public DoubleLatch(int numberOfContestants, boolean awaitUninterruptibly) {
        this.startSignal = new CountDownLatch(numberOfContestants);
        this.finishSignal = new CountDownLatch(numberOfContestants);
        this.awaitUninterruptibly = awaitUninterruptibly;
    }

    public void startAndWaitForAllToStartAndFinish() {
        this.startAndWaitForAllToStart();
        this.waitForAllToFinish();
    }

    public void startAndWaitForAllToStart() {
        this.start();
        this.waitForAllToStart();
    }

    public void start() {
        this.startSignal.countDown();
    }

    public void waitForAllToStart() {
        DoubleLatch.awaitLatch(this.startSignal, this.awaitUninterruptibly);
    }

    public void finishAndWaitForAllToFinish() {
        this.finish();
        this.waitForAllToFinish();
    }

    public void finish() {
        this.finishSignal.countDown();
    }

    public void waitForAllToFinish() {
        DoubleLatch.awaitLatch(this.finishSignal, this.awaitUninterruptibly);
    }

    public static void awaitLatch(CountDownLatch latch) {
        DoubleLatch.awaitLatch(latch, false);
    }

    public static void awaitLatch(CountDownLatch latch, boolean uninterruptedWaiting) {
        long now = System.currentTimeMillis();
        long deadline = System.currentTimeMillis() + FIVE_MINUTES;
        while (now < deadline) {
            block4: {
                try {
                    long waitingTime = Math.min(Math.max(0L, deadline - now), 5000L);
                    if (latch.await(waitingTime, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                    Thread.yield();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    if (uninterruptedWaiting) break block4;
                    throw new RuntimeException("Thread interrupted while waiting on latch", e);
                }
            }
            now = System.currentTimeMillis();
        }
        throw new AssertionError((Object)"Latch specified waiting time elapsed.");
    }

    public String toString() {
        return super.toString() + "[Start[" + this.startSignal.getCount() + "], Finish[" + this.finishSignal.getCount() + "]]";
    }
}

