/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.guard;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.test.extension.guard.AnnotationClassCollectorVisitor;
import org.neo4j.test.extension.guard.FieldClassCollectorVisitor;
import org.neo4j.test.extension.guard.MethodClassCollectorVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class DependenciesCollector
extends ClassVisitor {
    private static final int API_VERSION = 458752;
    private final AnnotationVisitor annotationVisitor;
    private final MethodVisitor methodVisitor;
    private final FieldVisitor fieldVisitor;
    private final Set<String> descriptors = new HashSet<String>();

    DependenciesCollector() {
        super(458752);
        this.annotationVisitor = new AnnotationClassCollectorVisitor(458752, this.descriptors);
        this.methodVisitor = new MethodClassCollectorVisitor(458752, this.descriptors, this.annotationVisitor);
        this.fieldVisitor = new FieldClassCollectorVisitor(458752, this.descriptors, this.annotationVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.descriptors.add(descriptor);
        return this.annotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.descriptors.add(descriptor);
        return this.annotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.descriptors.add(descriptor);
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return this.methodVisitor;
    }

    Set<String> getJunitTestClasses() {
        return this.descriptors.stream().filter(d -> d.startsWith("org/junit") || d.startsWith("Lorg/junit")).map(d -> d.startsWith("o") ? Type.getObjectType((String)d) : Type.getType((String)d)).map(Type::getClassName).collect(Collectors.toSet());
    }
}

