/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.timeout;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.neo4j.internal.utils.DumpUtils;
import org.neo4j.test.extension.StatefulFieldExtension;
import org.opentest4j.IncompleteExecutionException;

public class VerboseExceptionExtension
extends StatefulFieldExtension<Void>
implements TestExecutionExceptionHandler {
    private static final String VERBOSE_EXCEPTION = "verboseTimeout";
    private static final ExtensionContext.Namespace VERBOSE_EXCEPTION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"verboseTimeout"});

    @Override
    protected String getFieldKey() {
        return VERBOSE_EXCEPTION;
    }

    @Override
    protected Class<Void> getFieldType() {
        return Void.class;
    }

    @Override
    protected Void createField(ExtensionContext extensionContext) {
        return null;
    }

    @Override
    protected ExtensionContext.Namespace getNameSpace() {
        return VERBOSE_EXCEPTION_NAMESPACE;
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (!(throwable instanceof IncompleteExecutionException)) {
            System.err.println(String.format("=== Test %s-%s timed out, dumping more information ===", context.getRequiredTestMethod().getName(), context.getDisplayName()));
            System.err.println("=== Thread dump ===");
            System.err.println(DumpUtils.threadDump());
        }
        throw throwable;
    }
}

