/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.scheduler;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.resources.Profiler;
import org.neo4j.scheduler.ActiveGroup;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.CallableExecutorService;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;
import org.neo4j.test.scheduler.DaemonThreadFactory;

public class ThreadPoolJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private final ExecutorService executor;

    public ThreadPoolJobScheduler() {
        this("ThreadPoolScheduler");
    }

    public ThreadPoolJobScheduler(String prefix) {
        this.executor = Executors.newCachedThreadPool(new DaemonThreadFactory(prefix));
    }

    public ThreadPoolJobScheduler(ExecutorService executor) {
        this.executor = executor;
    }

    public void setTopLevelGroupName(String name) {
        throw new UnsupportedOperationException();
    }

    public void setParallelism(Group group, int parallelism) {
    }

    public void setThreadFactory(Group group, SchedulerThreadFactoryFactory threadFactory) {
        throw new UnsupportedOperationException();
    }

    public CallableExecutor executor(Group group) {
        return new CallableExecutorService(this.executor);
    }

    public ThreadFactory threadFactory(Group group) {
        throw new UnsupportedOperationException();
    }

    public <T> JobHandle<T> schedule(Group group, Callable<T> job) {
        return new FutureJobHandle<T>(this.executor.submit(job));
    }

    public JobHandle<?> schedule(Group group, Runnable job) {
        return new FutureJobHandle(this.executor.submit(job));
    }

    public JobHandle<?> schedule(Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    public Stream<ActiveGroup> activeGroups() {
        throw new UnsupportedOperationException();
    }

    public void profileGroup(Group group, Profiler profiler) {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.executor.shutdown();
        if (ThreadPoolJobScheduler.isNotShutdown(this.executor)) {
            this.executor.shutdownNow();
            if (ThreadPoolJobScheduler.isNotShutdown(this.executor)) {
                throw new IllegalStateException("Executor did not shutdown in time: " + this.executor);
            }
        }
    }

    private static boolean isNotShutdown(ExecutorService executor) {
        try {
            return !executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    private static class FutureJobHandle<V>
    implements JobHandle<V> {
        private final Future<V> future;

        FutureJobHandle(Future<V> future) {
            this.future = future;
        }

        public void cancel() {
            this.future.cancel(false);
        }

        public void waitTermination() throws InterruptedException, ExecutionException {
            this.future.get();
        }

        public void waitTermination(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.future.get(timeout, unit);
        }

        public V get() throws ExecutionException, InterruptedException {
            return this.future.get();
        }
    }
}

