/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.scheduler;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.resources.Profiler;
import org.neo4j.scheduler.ActiveGroup;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;
import org.neo4j.test.scheduler.DaemonThreadFactory;

public class ThreadPoolJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private final ExecutorService executor;
    private final ThreadFactory threadFactory;

    public ThreadPoolJobScheduler() {
        this("ThreadPoolScheduler");
    }

    public ThreadPoolJobScheduler(String prefix) {
        this.threadFactory = new DaemonThreadFactory(prefix);
        this.executor = Executors.newCachedThreadPool(this.threadFactory);
    }

    public ThreadPoolJobScheduler(ExecutorService executor, ThreadFactory threadFactory) {
        this.executor = executor;
        this.threadFactory = threadFactory;
    }

    public void setTopLevelGroupName(String name) {
        throw new UnsupportedOperationException();
    }

    public void setParallelism(Group group, int parallelism) {
        throw new UnsupportedOperationException();
    }

    public void setThreadFactory(Group group, SchedulerThreadFactoryFactory threadFactory) {
        throw new UnsupportedOperationException();
    }

    public Executor executor(Group group) {
        return this.executor;
    }

    public ThreadFactory threadFactory(Group group) {
        return this.threadFactory;
    }

    public JobHandle schedule(Group group, Runnable job) {
        return new FutureJobHandle(this.executor.submit(job));
    }

    public JobHandle schedule(Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    public JobHandle scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    public JobHandle scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    public Stream<ActiveGroup> activeGroups() {
        throw new UnsupportedOperationException();
    }

    public void profileGroup(Group group, Profiler profiler) {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.executor.shutdown();
        if (ThreadPoolJobScheduler.isNotShutdown(this.executor)) {
            this.executor.shutdownNow();
            if (ThreadPoolJobScheduler.isNotShutdown(this.executor)) {
                throw new IllegalStateException("Executor did not shutdown in time: " + this.executor);
            }
        }
    }

    private static boolean isNotShutdown(ExecutorService executor) {
        try {
            return !executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    private static class FutureJobHandle<V>
    implements JobHandle {
        private final Future<V> future;

        FutureJobHandle(Future<V> future) {
            this.future = future;
        }

        public void cancel() {
            this.future.cancel(false);
        }

        public void waitTermination() throws InterruptedException, ExecutionException, CancellationException {
            this.future.get();
        }

        public void waitTermination(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.future.get(timeout, unit);
        }
    }
}

