/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.test.scheduler.JobSchedulerAdapter;

public class OnDemandJobScheduler
extends JobSchedulerAdapter {
    private List<Runnable> jobs = new CopyOnWriteArrayList<Runnable>();
    private final boolean removeJobsAfterExecution;

    public OnDemandJobScheduler() {
        this(true);
    }

    public OnDemandJobScheduler(boolean removeJobsAfterExecution) {
        this.removeJobsAfterExecution = removeJobsAfterExecution;
    }

    @Override
    public Executor executor(Group group) {
        return command -> this.jobs.add(command);
    }

    @Override
    public JobHandle schedule(Group group, Runnable job) {
        this.jobs.add(job);
        return new OnDemandJobHandle();
    }

    @Override
    public JobHandle schedule(Group group, Runnable job, long initialDelay, TimeUnit timeUnit) {
        this.jobs.add(job);
        return new OnDemandJobHandle();
    }

    @Override
    public JobHandle scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.jobs.add(runnable);
        return new OnDemandJobHandle();
    }

    @Override
    public JobHandle scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.jobs.add(runnable);
        return new OnDemandJobHandle();
    }

    public Runnable getJob() {
        return this.jobs.isEmpty() ? null : this.jobs.get(0);
    }

    public void runJob() {
        for (Runnable job : this.jobs) {
            job.run();
            if (!this.removeJobsAfterExecution) continue;
            this.jobs.remove(job);
        }
    }

    private class OnDemandJobHandle
    implements JobHandle {
        private OnDemandJobHandle() {
        }

        public void cancel() {
            OnDemandJobScheduler.this.jobs.clear();
        }

        public void waitTermination() {
        }

        public void waitTermination(long timeout, TimeUnit unit) {
        }
    }
}

