/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.Map;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.Serializer;

public abstract class MappingRepresentation
extends Representation {
    MappingRepresentation(RepresentationType type) {
        super(type);
    }

    public MappingRepresentation(String type) {
        super(type);
    }

    @Override
    String serialize(RepresentationFormat format, URI baseUri, ExtensionInjector extensions) {
        MappingWriter writer = format.serializeMapping(this.type);
        Serializer.injectExtensions(writer, this, baseUri, extensions);
        this.serialize(new MappingSerializer(writer, baseUri, extensions));
        writer.done();
        return format.complete(writer);
    }

    protected abstract void serialize(MappingSerializer var1);

    @Override
    void addTo(ListSerializer serializer) {
        serializer.addMapping(this);
    }

    @Override
    void putTo(MappingSerializer serializer, String key) {
        serializer.putMapping(key, this);
    }

    public static MappingRepresentation stringMap(String type, final Map<String, String> map) {
        return new MappingRepresentation(type){

            @Override
            protected void serialize(MappingSerializer serializer) {
                for (Map.Entry pair : map.entrySet()) {
                    serializer.putString((String)pair.getKey(), (String)pair.getValue());
                }
            }
        };
    }
}

