/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.neo4j.server.rest.repr.ExtensibleRepresentation;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.RepresentationType;

abstract class Serializer {
    private final URI baseUri;
    private final ExtensionInjector extensions;

    Serializer(URI baseUri, ExtensionInjector extensions) {
        this.baseUri = baseUri;
        this.extensions = extensions;
    }

    final void serialize(MappingWriter mapping, MappingRepresentation value) {
        Serializer.injectExtensions(mapping, value, this.baseUri, this.extensions);
        value.serialize(new MappingSerializer(mapping, this.baseUri, this.extensions));
        mapping.done();
    }

    static void injectExtensions(MappingWriter mapping, MappingRepresentation value, URI baseUri, ExtensionInjector injector) {
        if (value instanceof ExtensibleRepresentation && injector != null) {
            Map<String, List<String>> extData = injector.getExensionsFor(value.type.extend);
            String entityIdentity = ((ExtensibleRepresentation)((Object)value)).getIdentity();
            if (extData != null) {
                MappingWriter extensions = mapping.newMapping(RepresentationType.PLUGINS, "extensions");
                for (Map.Entry<String, List<String>> ext : extData.entrySet()) {
                    MappingWriter extension = extensions.newMapping(RepresentationType.PLUGIN, ext.getKey());
                    for (String method : ext.getValue()) {
                        StringBuilder path = new StringBuilder("/ext/").append(ext.getKey());
                        path.append("/").append(value.type.valueName);
                        if (entityIdentity != null) {
                            path.append("/").append(entityIdentity);
                        }
                        path.append("/").append(method);
                        extension.writeValue(RepresentationType.URI, method, (Object)Serializer.joinBaseWithRelativePath(baseUri, path.toString()));
                    }
                }
            }
        }
    }

    final void serialize(ListWriter list, ListRepresentation value) {
        value.serialize(new ListSerializer(list, this.baseUri, this.extensions));
        list.done();
    }

    final URI relativeUri(String path) {
        return URI.create(Serializer.joinBaseWithRelativePath(this.baseUri, path));
    }

    final String relativeTemplate(String path) {
        return Serializer.joinBaseWithRelativePath(this.baseUri, path);
    }

    static String joinBaseWithRelativePath(URI baseUri, String path) {
        String base = baseUri.toString();
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                return base + path.substring(1);
            }
        } else if (!path.startsWith("/")) {
            return base + "/" + path;
        }
        return base + path;
    }

    protected void checkThatItIsBuiltInType(Object value) {
        if (!"java.lang".equals(value.getClass().getPackage().getName())) {
            throw new IllegalArgumentException("Unsupported number type: " + value.getClass());
        }
    }
}

