/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.enrichment;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.enrichment.Enrichment;
import org.neo4j.storageengine.api.enrichment.TxMetadata;

public interface EnrichmentCommand
extends StorageCommand {
    public static final byte COMMAND_CODE = 30;

    public TxMetadata metadata();

    public Optional<Enrichment> enrichment();

    public static Enrichment.Read extractForReading(EnrichmentCommand command) throws IOException {
        return (Enrichment.Read)command.enrichment().filter(Enrichment.Read.class::isInstance).orElseThrow(() -> new IOException("The enrichment specified is for writing"));
    }

    public static Enrichment.Write extractForWriting(EnrichmentCommand command) throws IOException {
        return (Enrichment.Write)command.enrichment().filter(Enrichment.Write.class::isInstance).orElseThrow(() -> new IOException("The enrichment specified is for reading"));
    }
}

