/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;

public abstract class PropertySelection {
    private final boolean keysOnly;
    public static final PropertySelection ALL_PROPERTIES = PropertySelection.allProperties(false);
    public static final PropertySelection ALL_PROPERTY_KEYS = PropertySelection.allProperties(true);

    protected PropertySelection(boolean keysOnly) {
        this.keysOnly = keysOnly;
    }

    public abstract boolean isLimited();

    public abstract int numberOfKeys();

    public abstract int key(int var1);

    public abstract boolean test(int var1);

    public boolean isKeysOnly() {
        return this.keysOnly;
    }

    public String toString() {
        return String.format("Property%sSelection", this.keysOnly ? "Key" : "");
    }

    public static PropertySelection selection(int key) {
        return SingleKey.singleKey(false, key);
    }

    public static PropertySelection selection(int ... keys) {
        return PropertySelection.selection(false, keys);
    }

    public static PropertySelection onlyKeysSelection(int ... keys) {
        return PropertySelection.selection(true, keys);
    }

    private static PropertySelection selection(boolean keysOnly, int[] keys) {
        if (keys == null) {
            return keysOnly ? ALL_PROPERTY_KEYS : ALL_PROPERTIES;
        }
        if (keys.length == 0) {
            throw new IllegalArgumentException("Can't make a property selection of zero keys");
        }
        return keys.length == 1 ? SingleKey.singleKey(keysOnly, keys[0]) : new MultipleKeys(keysOnly, keys);
    }

    private static PropertySelection allProperties(boolean keysOnly) {
        return new PropertySelection(keysOnly){

            @Override
            public boolean isLimited() {
                return false;
            }

            @Override
            public int numberOfKeys() {
                return 1;
            }

            @Override
            public int key(int index) {
                return -1;
            }

            @Override
            public boolean test(int key) {
                return true;
            }

            @Override
            public String toString() {
                return super.toString() + "[*]";
            }
        };
    }

    private static class SingleKey
    extends PropertySelection {
        private static final int LOW_ID_THRESHOLD = 128;
        private static final PropertySelection[] SINGLE_LOW_ID_SELECTIONS = new PropertySelection[128];
        private static final PropertySelection[] SINGLE_LOW_ID_KEY_SELECTIONS = new PropertySelection[128];
        private final int key;

        private static PropertySelection singleKey(boolean keysOnly, int key) {
            if (key < 128 && key >= 0) {
                return keysOnly ? SINGLE_LOW_ID_KEY_SELECTIONS[key] : SINGLE_LOW_ID_SELECTIONS[key];
            }
            return new SingleKey(keysOnly, key);
        }

        private SingleKey(boolean keysOnly, int key) {
            super(keysOnly);
            this.key = key;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return 1;
        }

        @Override
        public int key(int index) {
            assert (index == 0);
            return this.key;
        }

        @Override
        public boolean test(int key) {
            return this.key == key;
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.key + "]";
        }

        static {
            for (int key = 0; key < SINGLE_LOW_ID_SELECTIONS.length; ++key) {
                SingleKey.SINGLE_LOW_ID_SELECTIONS[key] = new SingleKey(false, key);
                SingleKey.SINGLE_LOW_ID_KEY_SELECTIONS[key] = new SingleKey(true, key);
            }
        }
    }

    private static class MultipleKeys
    extends PropertySelection {
        private final int[] keys;

        private MultipleKeys(boolean keysOnly, int[] keys) {
            super(keysOnly);
            this.keys = (int[])keys.clone();
            Arrays.sort(this.keys);
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return this.keys.length;
        }

        @Override
        public int key(int index) {
            assert (index >= 0 && index < this.keys.length);
            return this.keys[index];
        }

        @Override
        public boolean test(int key) {
            for (int k : this.keys) {
                if (k != key) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return super.toString() + "[" + Arrays.toString(this.keys) + "]";
        }
    }
}

