/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.io.pagecache.OutOfDiskSpaceException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.CommandStream;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionStateBehaviour;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public interface StorageEngine
extends ReadableStorageEngine,
Lifecycle {
    public CommandCreationContext newCommandCreationContext();

    public StorageLocks createStorageLocks(ResourceLocker var1);

    public void addIndexUpdateListener(IndexUpdateListener var1);

    public List<StorageCommand> createCommands(ReadableTransactionState var1, StorageReader var2, CommandCreationContext var3, LockTracer var4, TxStateVisitor.Decorator var5, CursorContext var6, StoreCursors var7, MemoryTracker var8) throws KernelException;

    public List<StorageCommand> createUpgradeCommands(KernelVersion var1, KernelVersion var2);

    public void lockRecoveryCommands(CommandStream var1, LockService var2, LockGroup var3, TransactionApplicationMode var4) throws IOException;

    public void apply(CommandBatchToApply var1, TransactionApplicationMode var2) throws Exception;

    public void rollback(ReadableTransactionState var1, CursorContext var2);

    public void checkpoint(DatabaseFlushEvent var1, CursorContext var2) throws IOException;

    public void dumpDiagnostics(InternalLog var1, DiagnosticsLogger var2);

    public void shutdown();

    public void listStorageFiles(Collection<StoreFileMetadata> var1, Collection<StoreFileMetadata> var2);

    public StoreId retrieveStoreId();

    public Lifecycle schemaAndTokensLifecycle();

    public MetadataProvider metadataProvider();

    public CountsAccessor countsAccessor();

    public StoreEntityCounters storeEntityCounters();

    default public TransactionStateBehaviour transactionStateBehaviour() {
        return TransactionStateBehaviour.DEFAULT_BEHAVIOUR;
    }

    public void preAllocateStoreFilesForCommands(CommandBatchToApply var1, TransactionApplicationMode var2) throws OutOfDiskSpaceException, IOException;
}

