/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConsistencySummaryStatistics {
    private final Map<String, AtomicInteger> inconsistenciesPerType = new ConcurrentHashMap<String, AtomicInteger>();
    private final AtomicLong errorCount = new AtomicLong();
    private final AtomicLong warningCount = new AtomicLong();
    private final List<String> genericErrors = new CopyOnWriteArrayList<String>();

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append(" {").append("%n\tNumber of errors: ").append(this.errorCount).append("%n\tNumber of warnings: ").append(this.warningCount);
        for (Map.Entry<String, AtomicInteger> entry : this.inconsistenciesPerType.entrySet()) {
            if (entry.getValue().get() == 0) continue;
            result.append("%n\tNumber of inconsistent ").append(entry.getKey()).append(" records: ").append(entry.getValue());
        }
        if (!this.genericErrors.isEmpty()) {
            result.append("%n\tGeneric errors: ");
            this.genericErrors.forEach(message -> result.append("%n\t\t").append((String)message));
        }
        return result.append("%n}").toString().formatted(new Object[0]);
    }

    public boolean isConsistent() {
        return this.getTotalInconsistencyCount() == 0L;
    }

    public int getInconsistencyCountForRecordType(String type) {
        AtomicInteger count = this.inconsistenciesPerType.get(type);
        return count != null ? count.get() : 0;
    }

    public long getTotalInconsistencyCount() {
        return this.errorCount.get() - (long)this.genericErrors.size();
    }

    public long getTotalWarningCount() {
        return this.warningCount.get();
    }

    public List<String> getGenericErrors() {
        return Collections.unmodifiableList(this.genericErrors);
    }

    public void update(String type, int errors, int warnings) {
        if (errors > 0) {
            this.inconsistenciesPerType.computeIfAbsent(type, t -> new AtomicInteger()).addAndGet(errors);
            this.errorCount.addAndGet(errors);
        }
        if (warnings > 0) {
            this.warningCount.addAndGet(warnings);
        }
    }

    public void genericError(String message) {
        this.errorCount.incrementAndGet();
        this.genericErrors.add(message);
    }
}

