/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.function.Function;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.token.api.TokenIdPrettyPrinter;

public class RelationshipPropertyExistenceException
extends ConstraintValidationException {
    private final RelationTypeSchemaDescriptor schema;
    private final long relationshipId;

    @Deprecated
    private RelationshipPropertyExistenceException(RelationTypeSchemaDescriptor schema, Function<RelationTypeSchemaDescriptor, ConstraintDescriptor> constraintFunc, ConstraintValidationException.Phase phase, long relationshipId, TokenNameLookup tokenNameLookup) {
        super(constraintFunc.apply(schema), phase, String.format("Relationship(%s)", relationshipId), tokenNameLookup);
        this.schema = schema;
        this.relationshipId = relationshipId;
    }

    private RelationshipPropertyExistenceException(ErrorGqlStatusObject gqlStatusObject, RelationTypeSchemaDescriptor schema, Function<RelationTypeSchemaDescriptor, ConstraintDescriptor> constraintFunc, ConstraintValidationException.Phase phase, long relationshipId, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, constraintFunc.apply(schema), phase, String.format("Relationship(%s)", relationshipId), tokenNameLookup);
        this.schema = schema;
        this.relationshipId = relationshipId;
    }

    public static RelationshipPropertyExistenceException propertyPresenceViolation(RelationTypeSchemaDescriptor schema, TokenNameLookup tokenHolders, ConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long relationshipId) {
        int[] propIds = schema.getPropertyIds();
        String[] propKeyNames = new String[propIds.length];
        for (int i = 0; i < propIds.length; ++i) {
            propKeyNames[i] = tokenHolders.propertyKeyGetName(propIds[i]);
        }
        ErrorGqlStatusObject gql = GqlHelper.getGql22N77_relationships((long)relationshipId, (String)tokenHolders.relationshipTypeGetName(schema.getRelTypeId()), (String[])propKeyNames);
        return new RelationshipPropertyExistenceException(gql, schema, ignored -> descriptor, phase, relationshipId, tokenHolders);
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        boolean pluralProps = this.schema.getPropertyIds().length > 1;
        String propertyNoun = pluralProps ? "properties" : "property";
        String sep = pluralProps ? "" : "`";
        String props = pluralProps ? TokenIdPrettyPrinter.niceQuotedProperties((TokenNameLookup)tokenNameLookup, (int[])this.schema.getPropertyIds()) : tokenNameLookup.propertyKeyGetName(this.schema.getPropertyId());
        return String.format("Relationship(%s) with type `%s` must have the %s %s%s%s", this.relationshipId, tokenNameLookup.relationshipTypeGetName(this.schema.getRelTypeId()), propertyNoun, sep, props, sep);
    }
}

