/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.Serializable;
import java.util.List;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;

public enum KernelVersion {
    V2_3(-10),
    V4_0(1),
    V4_2(2),
    V4_3_D4(3),
    V4_4(4),
    V5_0(5),
    V5_7(6),
    V5_8(7),
    V5_9(8),
    V5_10(9),
    V5_11(10),
    V5_12(11),
    V5_13(12),
    V5_14(13),
    V5_15(14),
    V5_18(15),
    V5_19(16),
    V5_20(17),
    V5_22(18),
    V5_23(19),
    V5_25(20),
    GLORIOUS_FUTURE(127);

    public static final KernelVersion EARLIEST;
    private static final KernelVersion LATEST;
    public static final KernelVersion VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED;
    public static final KernelVersion VERSION_RANGE_POINT_TEXT_INDEXES_ARE_INTRODUCED;
    public static final KernelVersion VERSION_LITTLE_ENDIAN_TX_LOG_INTRODUCED;
    public static final KernelVersion VERSION_TRIGRAM_INDEX_INTRODUCED;
    public static final KernelVersion VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED;
    public static final KernelVersion VERSION_INDEX_USAGE_STATISTICS_INTRODUCED;
    public static final KernelVersion VERSION_CDC_INTRODUCED;
    public static final KernelVersion VERSION_TYPE_CONSTRAINTS_INTRODUCED;
    public static final KernelVersion VERSION_BLOCKFORMAT_INTRODUCED;
    public static final KernelVersion VERSION_UNIONS_AND_LIST_TYPE_CONSTRAINTS_INTRODUCED;
    public static final KernelVersion VERSION_NODE_VECTOR_INDEX_INTRODUCED;
    public static final KernelVersion VERSION_CDC_USER_METADATA_INTRODUCED;
    public static final KernelVersion CLUSTER_FALLBACK_IN_RAW;
    public static final KernelVersion VERSION_CDC_LOGICAL_KEY_CHANGES;
    public static final KernelVersion VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED;
    public static final KernelVersion VERSION_VECTOR_2_INTRODUCED;
    public static final KernelVersion VERSION_CDC_CHECKSUMS_INTRODUCED;
    public static final KernelVersion VERSION_APPEND_INDEX_INTRODUCED;
    public static final KernelVersion VERSION_CHECKPOINT_NOT_COMPLETED_POSITION_INTRODUCED;
    public static final KernelVersion VERSION_VECTOR_QUANTIZATION_AND_HYPER_PARAMS;
    public static final KernelVersion VERSION_PARTITIONED_BLOCK_INDEX_RULE_VALUES;
    public static final KernelVersion VERSION_PARTITIONED_BLOCK_TOKENS;
    public static final KernelVersion LATEST_SCHEMA_CHANGE;
    public static final KernelVersion DEFAULT_BOOTSTRAP_VERSION;
    public static final List<KernelVersion> VERSIONS;
    private static final ImmutableByteObjectMap<KernelVersion> VERSION_MAP;
    private final byte version;

    public static KernelVersion getLatestVersion(Config config) {
        Byte version = (Byte)config.get(GraphDatabaseInternalSettings.latest_kernel_version);
        return version == null ? LATEST : KernelVersion.getForVersion(version);
    }

    private KernelVersion(byte version) {
        this.version = version;
    }

    public byte version() {
        return this.version;
    }

    public boolean isLatest(Config config) {
        return this == KernelVersion.getLatestVersion(config);
    }

    public boolean isGreaterThan(KernelVersion other) {
        return this.version > other.version;
    }

    public boolean isGreaterThan(byte other) {
        return this.version > other;
    }

    public boolean isLessThan(KernelVersion other) {
        return this.version < other.version;
    }

    public boolean isLessThan(byte other) {
        return this.version < other;
    }

    public boolean isAtLeast(KernelVersion other) {
        return this.version >= other.version;
    }

    public String toString() {
        return "KernelVersion{" + this.name() + ",version=" + this.version + "}";
    }

    public static KernelVersion getForVersion(byte version) {
        KernelVersion kernelVersion = (KernelVersion)((Object)VERSION_MAP.get(version));
        if (kernelVersion == null) {
            throw new IllegalArgumentException("No matching " + KernelVersion.class.getSimpleName() + " for version " + version);
        }
        return kernelVersion;
    }

    static {
        EARLIEST = V4_2;
        LATEST = V5_25;
        VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED = V4_3_D4;
        VERSION_RANGE_POINT_TEXT_INDEXES_ARE_INTRODUCED = V4_4;
        VERSION_LITTLE_ENDIAN_TX_LOG_INTRODUCED = V5_0;
        VERSION_TRIGRAM_INDEX_INTRODUCED = V5_0;
        VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED = V5_7;
        VERSION_INDEX_USAGE_STATISTICS_INTRODUCED = V5_8;
        VERSION_CDC_INTRODUCED = V5_8;
        VERSION_TYPE_CONSTRAINTS_INTRODUCED = V5_9;
        VERSION_BLOCKFORMAT_INTRODUCED = V5_10;
        VERSION_UNIONS_AND_LIST_TYPE_CONSTRAINTS_INTRODUCED = V5_10;
        VERSION_NODE_VECTOR_INDEX_INTRODUCED = V5_11;
        VERSION_CDC_USER_METADATA_INTRODUCED = V5_12;
        CLUSTER_FALLBACK_IN_RAW = V5_12;
        VERSION_CDC_LOGICAL_KEY_CHANGES = V5_15;
        VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED = GLORIOUS_FUTURE;
        VERSION_VECTOR_2_INTRODUCED = V5_18;
        VERSION_CDC_CHECKSUMS_INTRODUCED = V5_19;
        VERSION_APPEND_INDEX_INTRODUCED = V5_20;
        VERSION_CHECKPOINT_NOT_COMPLETED_POSITION_INTRODUCED = V5_22;
        VERSION_VECTOR_QUANTIZATION_AND_HYPER_PARAMS = V5_23;
        VERSION_PARTITIONED_BLOCK_INDEX_RULE_VALUES = V5_23;
        VERSION_PARTITIONED_BLOCK_TOKENS = V5_25;
        LATEST_SCHEMA_CHANGE = VERSION_VECTOR_QUANTIZATION_AND_HYPER_PARAMS;
        DEFAULT_BOOTSTRAP_VERSION = V5_0;
        VERSIONS = List.of(KernelVersion.values());
        VERSION_MAP = ByteObjectMaps.immutable.from(VERSIONS, KernelVersion::version, (Function & Serializable)v -> v);
    }
}

