/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Objects;

public final class IndexSamplingMode {
    public static final long NO_WAIT = 0L;
    private final boolean sampleOnlyIfUpdated;
    private final long millisToWaitForCompletion;
    private final String description;

    private IndexSamplingMode(boolean sampleOnlyIfUpdated, long millisToWaitForCompletion, String description) {
        this.sampleOnlyIfUpdated = sampleOnlyIfUpdated;
        this.millisToWaitForCompletion = millisToWaitForCompletion;
        this.description = description;
    }

    public boolean sampleOnlyIfUpdated() {
        return this.sampleOnlyIfUpdated;
    }

    public long millisToWaitForCompletion() {
        return this.millisToWaitForCompletion;
    }

    public String toString() {
        return this.description;
    }

    public static IndexSamplingMode foregroundRebuildUpdated(long millisToWaitForCompletion) {
        return new IndexSamplingMode(true, millisToWaitForCompletion, "FOREGROUND-REBUILD UPDATED");
    }

    public static IndexSamplingMode backgroundRebuildAll() {
        return new IndexSamplingMode(false, 0L, "BACKGROUND-REBUILD ALL");
    }

    public static IndexSamplingMode backgroundRebuildUpdated() {
        return new IndexSamplingMode(true, 0L, "BACKGROUND-REBUILD UPDATED");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSamplingMode that = (IndexSamplingMode)o;
        return this.sampleOnlyIfUpdated == that.sampleOnlyIfUpdated && this.millisToWaitForCompletion == that.millisToWaitForCompletion && this.description.equals(that.description);
    }

    public int hashCode() {
        return Objects.hash(this.sampleOnlyIfUpdated, this.millisToWaitForCompletion, this.description);
    }
}

