/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions;

import java.util.Objects;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;

public class EntityNotFoundException
extends KernelException {
    private final EntityType entityType;
    private final String entityId;

    public EntityNotFoundException(EntityType entityType, String entityId) {
        super((Status)Status.Statement.EntityNotFound, "Unable to load %s %s.", new Object[]{entityType.name(), entityId});
        this.entityType = Objects.requireNonNull(entityType);
        this.entityId = Objects.requireNonNull(entityId);
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public String entityId() {
        return this.entityId;
    }
}

