/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.function.Supplier;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.storageengine.api.StorageLocks;

public class EntityLocks
implements Locks {
    private final StorageLocks storageLocks;
    private final Supplier<LockTracer> lockTracer;
    private final LockManager.Client lockClient;
    private final AssertOpen assertOpen;

    public EntityLocks(StorageLocks storageLocks, Supplier<LockTracer> lockTracer, LockManager.Client lockClient, AssertOpen assertOpen) {
        this.storageLocks = storageLocks;
        this.lockTracer = lockTracer;
        this.lockClient = lockClient;
        this.assertOpen = assertOpen;
    }

    private void performCheckBeforeOperation() {
        this.assertOpen.assertOpen();
    }

    @Override
    public void acquireExclusiveNodeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.acquireExclusiveNodeLock(this.lockTracer.get(), ids);
    }

    @Override
    public void acquireExclusiveRelationshipLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.acquireExclusiveRelationshipLock(this.lockTracer.get(), ids);
    }

    @Override
    public void releaseExclusiveNodeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.releaseExclusiveNodeLock(ids);
    }

    @Override
    public void releaseExclusiveRelationshipLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.releaseExclusiveRelationshipLock(ids);
    }

    @Override
    public void acquireSharedNodeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.acquireSharedNodeLock(this.lockTracer.get(), ids);
    }

    @Override
    public void acquireSharedRelationshipLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.acquireSharedRelationshipLock(this.lockTracer.get(), ids);
    }

    @Override
    public void acquireSharedRelationshipTypeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.lockClient.acquireShared(this.lockTracer.get(), ResourceType.RELATIONSHIP_TYPE, ids);
    }

    @Override
    public void acquireSharedLabelLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.lockClient.acquireShared(this.lockTracer.get(), ResourceType.LABEL, ids);
    }

    @Override
    public void releaseSharedNodeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.releaseSharedNodeLock(ids);
    }

    @Override
    public void releaseSharedRelationshipLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.releaseSharedRelationshipLock(ids);
    }

    @Override
    public void releaseSharedLabelLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.lockClient.releaseShared(ResourceType.LABEL, ids);
    }

    @Override
    public void releaseSharedRelationshipTypeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.lockClient.releaseShared(ResourceType.RELATIONSHIP_TYPE, ids);
    }

    @Override
    public void acquireSharedLookupLock(EntityType entityType) {
        this.performCheckBeforeOperation();
        this.acquireSharedSchemaLock(() -> SchemaDescriptors.forAnyEntityTokens((EntityType)entityType));
    }

    @Override
    public void releaseSharedLookupLock(EntityType entityType) {
        this.performCheckBeforeOperation();
        this.releaseSharedSchemaLock(() -> SchemaDescriptors.forAnyEntityTokens((EntityType)entityType));
    }

    @Override
    public void acquireSharedSchemaLock(SchemaDescriptorSupplier schemaLike) {
        SchemaDescriptor schema = schemaLike.schema();
        this.lockClient.acquireShared(this.lockTracer.get(), schema.keyType(), schema.lockingKeys());
    }

    @Override
    public void releaseSharedSchemaLock(SchemaDescriptorSupplier schemaLike) {
        SchemaDescriptor schema = schemaLike.schema();
        long[] lockingKeys = schema.lockingKeys();
        this.lockClient.releaseShared(schema.keyType(), lockingKeys);
    }

    @Override
    public void acquireSharedIndexEntryLock(long ... indexEntries) {
        this.lockClient.acquireShared(this.lockTracer.get(), ResourceType.INDEX_ENTRY, indexEntries);
    }

    @Override
    public void releaseSharedIndexEntryLock(long ... indexEntries) {
        this.lockClient.releaseShared(ResourceType.INDEX_ENTRY, indexEntries);
    }

    @Override
    public void acquireExclusiveIndexEntryLock(long ... indexEntries) {
        this.lockClient.acquireExclusive(this.lockTracer.get(), ResourceType.INDEX_ENTRY, indexEntries);
    }

    @Override
    public void releaseExclusiveIndexEntryLock(long ... indexEntries) {
        this.lockClient.releaseExclusive(ResourceType.INDEX_ENTRY, indexEntries);
    }
}

