/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

@FunctionalInterface
public interface IndexUpdateIgnoreStrategy {
    public static final IndexUpdateIgnoreStrategy NO_IGNORE = new IndexUpdateIgnoreStrategy(){

        @Override
        public boolean ignore(Value[] values) {
            return false;
        }

        @Override
        public <INDEX_KEY extends SchemaDescriptorSupplier> boolean ignore(ValueIndexEntryUpdate<INDEX_KEY> update) {
            return false;
        }

        @Override
        public <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> toEquivalentUpdate(ValueIndexEntryUpdate<INDEX_KEY> update) {
            return update;
        }
    };

    public boolean ignore(Value[] var1);

    default public <INDEX_KEY extends SchemaDescriptorSupplier> boolean ignore(ValueIndexEntryUpdate<INDEX_KEY> update) {
        if (update.updateMode() == UpdateMode.CHANGED) {
            return this.ignore(update.beforeValues()) && this.ignore(update.values());
        }
        return this.ignore(update.values());
    }

    default public <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> toEquivalentUpdate(ValueIndexEntryUpdate<INDEX_KEY> update) {
        boolean shouldAdd;
        if (update.updateMode() != UpdateMode.CHANGED) {
            return update;
        }
        Value[] beforeValues = update.beforeValues();
        Value[] afterValues = update.values();
        boolean shouldRemove = !this.ignore(beforeValues);
        boolean bl = shouldAdd = !this.ignore(afterValues);
        if (shouldRemove && shouldAdd) {
            return update;
        }
        Object key = update.indexKey();
        long entityId = update.getEntityId();
        if (shouldRemove) {
            return IndexEntryUpdate.remove(entityId, key, beforeValues);
        }
        if (shouldAdd) {
            return IndexEntryUpdate.add(entityId, key, afterValues);
        }
        throw new IllegalStateException("Attempted a " + UpdateMode.CHANGED + " update, which was not applicable to the index");
    }
}

