/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.messages.MessageUtil;

public class SecurityAuthorizationHandler {
    AbstractSecurityLog securityLog;

    public SecurityAuthorizationHandler(AbstractSecurityLog securityLog) {
        this.securityLog = securityLog;
    }

    public void assertAllowsCreateNode(SecurityContext securityContext, IntFunction<String> resolver, int[] labelIds) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsCreateNode(labelIds)) {
            String labels = null == labelIds ? "" : Arrays.stream(labelIds).mapToObj(resolver).collect(Collectors.joining(","));
            throw this.logAndGetAuthorizationException(securityContext, MessageUtil.createNodeWithLabelsDenied((String)labels, (String)securityContext.database(), (String)securityContext.description()));
        }
    }

    public void assertAllowsDeleteNode(SecurityContext securityContext, IntFunction<String> resolver, Supplier<TokenSet> labelSupplier) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsDeleteNode(labelSupplier)) {
            String labels = Arrays.stream(labelSupplier.get().all()).mapToObj(resolver).collect(Collectors.joining(","));
            throw this.logAndGetAuthorizationException(securityContext, String.format("Delete node with labels '%s' on database '%s' is not allowed for %s.", labels, securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsCreateRelationship(SecurityContext securityContext, IntFunction<String> resolver, int relType) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsCreateRelationship(relType)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Create relationship with type '%s' on database '%s' is not allowed for %s.", resolver.apply(relType), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsDeleteRelationship(SecurityContext securityContext, IntFunction<String> resolver, int relType) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsDeleteRelationship(relType)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Delete relationship with type '%s' on database '%s' is not allowed for %s.", resolver.apply(relType), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsSetLabel(SecurityContext securityContext, IntFunction<String> resolver, int labelId) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsSetLabel(labelId)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Set label for label '%s' on database '%s' is not allowed for %s.", resolver.apply(labelId), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsRemoveLabel(SecurityContext securityContext, IntFunction<String> resolver, int labelId) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsRemoveLabel(labelId)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Remove label for label '%s' on database '%s' is not allowed for %s.", resolver.apply(labelId), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsSetProperty(SecurityContext securityContext, IntFunction<String> resolver, TokenSet labelIds, int propertyKey) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsSetProperty(() -> labelIds, propertyKey)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Set property for property '%s' on database '%s' is not allowed for %s.", resolver.apply(propertyKey), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsSetProperty(SecurityContext securityContext, IntFunction<String> resolver, long relType, int propertyKey) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsSetProperty(() -> (int)relType, propertyKey)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Set property for property '%s' on database '%s' is not allowed for %s.", resolver.apply(propertyKey), securityContext.database(), securityContext.description()));
        }
    }

    public void assertSchemaWrites(SecurityContext securityContext, PrivilegeAction action) {
        AccessMode accessMode = securityContext.mode();
        switch (accessMode.allowsSchemaWrites(action)) {
            case NOT_GRANTED: {
                throw this.logAndGetAuthorizationException(securityContext, String.format("Schema operation '%s' on database '%s' is not allowed for %s.", new Object[]{action, securityContext.database(), securityContext.description()}));
            }
            case EXPLICIT_DENY: {
                throw this.logAndGetAuthorizationException(securityContext, String.format("Schema operation '%s' on database '%s' is denied for %s.", new Object[]{action, securityContext.database(), securityContext.description()}));
            }
        }
    }

    public void assertShowIndexAllowed(SecurityContext securityContext) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsShowIndex()) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Show indexes on database '%s' is not allowed for %s.", securityContext.database(), securityContext.description()));
        }
    }

    public void assertShowConstraintAllowed(SecurityContext securityContext) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsShowConstraint()) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Show constraints on database '%s' is not allowed for %s.", securityContext.database(), securityContext.description()));
        }
    }

    public final void assertAllowsTokenCreates(SecurityContext securityContext, PrivilegeAction action) {
        AccessMode accessMode = securityContext.mode();
        PermissionState permissionState = accessMode.allowsTokenCreates(action);
        if (!permissionState.allowsAccess()) {
            String errorDescriptor = permissionState == PermissionState.NOT_GRANTED ? "not allowed" : "denied";
            switch (action) {
                case CREATE_LABEL: {
                    throw this.logAndGetAuthorizationException(securityContext, String.format("Creating new node label on database '%s' is %s for %s. See GRANT CREATE NEW NODE LABEL ON DATABASE `%s`...", securityContext.database(), errorDescriptor, securityContext.description(), securityContext.database()));
                }
                case CREATE_PROPERTYKEY: {
                    throw this.logAndGetAuthorizationException(securityContext, String.format("Creating new property name on database '%s' is %s for %s. See GRANT CREATE NEW PROPERTY NAME ON DATABASE `%s`...", securityContext.database(), errorDescriptor, securityContext.description(), securityContext.database()));
                }
                case CREATE_RELTYPE: {
                    throw this.logAndGetAuthorizationException(securityContext, String.format("Creating new relationship type on database '%s' is %s for %s. See GRANT CREATE NEW RELATIONSHIP TYPE ON DATABASE `%s`...", securityContext.database(), errorDescriptor, securityContext.description(), securityContext.database()));
                }
            }
            throw this.logAndGetAuthorizationException(securityContext, String.format("'%s' operations on database '%s' are %s for %s.", new Object[]{action, securityContext.database(), errorDescriptor, securityContext.description()}));
        }
    }

    public void assertLoadAllowed(SecurityContext securityContext, URI uri, InetAddress inetAddress) {
        AccessMode accessMode = securityContext.mode();
        PermissionState permissionState = accessMode.allowsLoadAllData();
        if (permissionState == PermissionState.NOT_GRANTED) {
            permissionState = accessMode.allowsLoadUri(uri, inetAddress);
        } else if (permissionState == PermissionState.EXPLICIT_GRANT) {
            permissionState = permissionState.combine(accessMode.allowsLoadUri(uri, inetAddress));
        }
        if (!permissionState.allowsAccess()) {
            String errorDescriptor = permissionState == PermissionState.NOT_GRANTED ? "not allowed" : "denied";
            throw this.logAndGetAuthorizationException(securityContext, String.format("LOAD on URL '%s' is %s for %s.", uri, errorDescriptor, securityContext.description()));
        }
    }

    public AuthorizationViolationException logAndGetAuthorizationException(SecurityContext securityContext, String message) {
        this.securityLog.error(securityContext, message);
        return new AuthorizationViolationException(message);
    }

    public AuthorizationViolationException logAndGetAuthorizationException(SecurityContext securityContext, String message, Status status) {
        this.securityLog.error(securityContext, message);
        return new AuthorizationViolationException(message, status);
    }

    public static String generateCredentialsExpiredMessage(String message) {
        return String.format("%s%n%nThe credentials you provided were valid, but must be changed before you can use this instance. If this is the first time you are using Neo4j, this is to ensure you are not using the default credentials in production. If you are not using default credentials, you are getting this message because an administrator requires a password change.%nTo change your password, issue an `ALTER CURRENT USER SET PASSWORD FROM 'current password' TO 'new password'` statement against the system database.", message);
    }
}

