/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Neo4jLogMessage;
import org.neo4j.logging.log4j.Neo4jMapMessage;

public abstract class AbstractSecurityLog {
    protected InternalLog inner;

    protected AbstractSecurityLog(InternalLog inner) {
        this.inner = inner;
    }

    public void debug(String message) {
        this.inner.debug((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void debug(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.debug((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void info(String message) {
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void info(LoginContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void info(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void warn(String message) {
        this.inner.warn((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void warn(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.warn((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void error(String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void error(ClientConnectionInfo connectionInfo, String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(connectionInfo, null, null, message, null));
    }

    public void error(LoginContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void error(LoginContext context, String database, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), database, subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void error(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser()));
    }

    public boolean isDebugEnabled() {
        return this.inner.isDebugEnabled();
    }

    static class SecurityLogLine
    extends Neo4jMapMessage {
        private final String executingUser;
        private final String message;
        private final String authenticatedUser;

        SecurityLogLine(String message) {
            this(null, null, null, message, null);
        }

        SecurityLogLine(ClientConnectionInfo connectionInfo, String database, String executingUser, String message, String authenticatedUser) {
            super(7);
            String sourceString = connectionInfo != null ? connectionInfo.asConnectionDetails() : "";
            this.executingUser = executingUser;
            this.message = message.replaceAll("\\R+", " ");
            this.authenticatedUser = authenticatedUser;
            this.with("type", "security");
            this.with("source", sourceString);
            if (database != null) {
                this.with("database", database);
            }
            if (executingUser != null && !executingUser.isEmpty()) {
                this.with("executingUser", executingUser);
            }
            if (authenticatedUser != null && !authenticatedUser.isEmpty()) {
                this.with("authenticatedUser", authenticatedUser);
            }
            this.with("message", this.message);
        }

        protected void formatAsString(StringBuilder sb) {
            if (this.executingUser != null && !this.executingUser.isEmpty()) {
                if (this.executingUser.equals(this.authenticatedUser)) {
                    sb.append("[").append(Strings.escape((String)this.executingUser)).append("]: ");
                } else {
                    sb.append(String.format("[%s:%s]: ", Strings.escape((String)this.authenticatedUser), Strings.escape((String)this.executingUser)));
                }
            }
            sb.append(this.message);
        }
    }
}

