/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.storageengine.api.CommandVersion;

public enum TransactionApplicationMode {
    INTERNAL(false, false, true, false, CommandVersion.AFTER),
    EXTERNAL(true, true, true, false, CommandVersion.AFTER),
    RECOVERY(true, true, true, false, CommandVersion.AFTER),
    REVERSE_RECOVERY(false, false, false, false, CommandVersion.BEFORE),
    MVCC_ROLLBACK(false, false, true, true, CommandVersion.BEFORE);

    private final boolean needsHighIdTracking;
    private final boolean needsCacheInvalidation;
    private final boolean indexesAndCounts;
    private final boolean rollbackIdProcessing;
    private final CommandVersion version;

    private TransactionApplicationMode(boolean needsHighIdTracking, boolean needsCacheInvalidation, boolean indexesAndCounts, boolean rollbackIdProcessing, CommandVersion version) {
        this.needsHighIdTracking = needsHighIdTracking;
        this.needsCacheInvalidation = needsCacheInvalidation;
        this.indexesAndCounts = indexesAndCounts;
        this.rollbackIdProcessing = rollbackIdProcessing;
        this.version = version;
    }

    public boolean needsHighIdTracking() {
        return this.needsHighIdTracking;
    }

    public boolean needsCacheInvalidationOnUpdates() {
        return this.needsCacheInvalidation;
    }

    public boolean needsAuxiliaryStores() {
        return this.indexesAndCounts;
    }

    public CommandVersion version() {
        return this.version;
    }

    public boolean rollbackIdProcessing() {
        return this.rollbackIdProcessing;
    }

    public boolean isReverseStep() {
        return CommandVersion.BEFORE == this.version;
    }
}

