/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate.validation;

import java.util.Arrays;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.api.exceptions.Status;

public class TransactionConflictException
extends TransientFailureException {
    private static final String GENERIC_MESSAGE = "Transaction conflict validation failed.";
    private DatabaseFile databaseFile;
    private long observedVersion;
    private long highestClosed;
    private long[] nonVisibleTransactions;

    public TransactionConflictException(DatabaseFile databaseFile, VersionContext versionContext, long pageId) {
        super(TransactionConflictException.createMessage(databaseFile.getName(), pageId, versionContext));
        this.databaseFile = databaseFile;
        this.observedVersion = versionContext.chainHeadVersion();
        this.highestClosed = versionContext.highestClosed();
        this.nonVisibleTransactions = versionContext.notVisibleTransactionIds();
    }

    public TransactionConflictException(String message, Exception cause) {
        super(message, (Throwable)cause);
    }

    public TransactionConflictException(Exception cause) {
        this(GENERIC_MESSAGE, cause);
    }

    public TransactionConflictException(RecordDatabaseFile databaseFile, long pageId) {
        super(TransactionConflictException.createPageIdPagedMessage(databaseFile.getName(), pageId));
        this.databaseFile = databaseFile;
    }

    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public DatabaseFile getDatabaseFile() {
        return this.databaseFile;
    }

    public long getObservedVersion() {
        return this.observedVersion;
    }

    public long getHighestClosed() {
        return this.highestClosed;
    }

    public long[] getNonVisibleTransactions() {
        return this.nonVisibleTransactions;
    }

    public Status status() {
        return Status.Transaction.Outdated;
    }

    private static String createPageIdPagedMessage(String databaseFileName, long pageId) {
        return "Concurrent modification exception. Page " + pageId + " in '" + databaseFileName + "' store is already locked by other transaction validator.";
    }

    private static String createMessage(String databaseFileName, long pageId, VersionContext versionContext) {
        return "Concurrent modification exception. Page " + pageId + " in '" + databaseFileName + "' store is modified already by transaction " + versionContext.chainHeadVersion() + ", while ongoing transaction highest visible is: " + versionContext.highestClosed() + ", with not yet visible transaction ids are: " + Arrays.toString(versionContext.notVisibleTransactionIds()) + ".";
    }
}

