/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.StoreVersionIdentifier;

public interface StoreVersionCheck {
    public boolean isCurrentStoreVersionFullySupported(CursorContext var1);

    public MigrationCheckResult getAndCheckMigrationTargetVersion(String var1, CursorContext var2);

    public UpgradeCheckResult getAndCheckUpgradeTargetVersion(CursorContext var1);

    public String getIntroductionVersionFromVersion(StoreVersionIdentifier var1);

    public StoreVersionIdentifier findLatestVersion(String var1);

    public static enum UpgradeOutcome {
        NO_OP,
        UPGRADE_POSSIBLE,
        STORE_VERSION_RETRIEVAL_FAILURE,
        UNSUPPORTED_TARGET_VERSION;

    }

    public record UpgradeCheckResult(UpgradeOutcome outcome, StoreVersionIdentifier versionToUpgradeFrom, StoreVersionIdentifier versionToUpgradeTo, Exception cause) {
    }

    public static enum MigrationOutcome {
        NO_OP,
        MIGRATION_POSSIBLE,
        STORE_VERSION_RETRIEVAL_FAILURE,
        UNSUPPORTED_MIGRATION_PATH,
        UNSUPPORTED_TARGET_VERSION;

    }

    public record MigrationCheckResult(MigrationOutcome outcome, StoreVersionIdentifier versionToMigrateFrom, StoreVersionIdentifier versionToMigrateTo, Exception cause) {
    }
}

