/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.storageengine.api.RelationshipSelection;

public final class RelationshipSelections {
    private RelationshipSelections() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static RelationshipTraversalCursor outgoingCursor(CursorFactory cursors, NodeCursor node, int[] types, PageCursorTracer cursorTracer) {
        return RelationshipSelections.relationshipsCursor(cursors.allocateRelationshipTraversalCursor(cursorTracer), node, types, Direction.OUTGOING);
    }

    public static RelationshipTraversalCursor outgoingCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        return RelationshipSelections.relationshipsCursor(traversalCursor, node, types, Direction.OUTGOING);
    }

    public static RelationshipTraversalCursor incomingCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        return RelationshipSelections.relationshipsCursor(traversalCursor, node, types, Direction.INCOMING);
    }

    public static RelationshipTraversalCursor incomingCursor(CursorFactory cursors, NodeCursor node, int[] types, PageCursorTracer cursorTracer) {
        return RelationshipSelections.relationshipsCursor(cursors.allocateRelationshipTraversalCursor(cursorTracer), node, types, Direction.INCOMING);
    }

    public static RelationshipTraversalCursor allCursor(CursorFactory cursors, NodeCursor node, int[] types, PageCursorTracer cursorTracer) {
        return RelationshipSelections.relationshipsCursor(cursors.allocateRelationshipTraversalCursor(cursorTracer), node, types, Direction.BOTH);
    }

    public static RelationshipTraversalCursor allCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        node.relationships(traversalCursor, RelationshipSelection.selection((int[])types, (Direction)Direction.BOTH));
        return traversalCursor;
    }

    public static RelationshipTraversalCursor relationshipsCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types, Direction outgoing) {
        try {
            node.relationships(traversalCursor, RelationshipSelection.selection((int[])types, (Direction)outgoing));
            return traversalCursor;
        }
        catch (Throwable t) {
            traversalCursor.close();
            throw t;
        }
    }

    public static <T> ResourceIterator<T> outgoingIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory, PageCursorTracer cursorTracer) {
        return new RelationshipEntityIterator<T>(RelationshipSelections.outgoingCursor(cursors, node, types, cursorTracer), factory);
    }

    public static <T> ResourceIterator<T> incomingIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory, PageCursorTracer cursorTracer) {
        return new RelationshipEntityIterator<T>(RelationshipSelections.incomingCursor(cursors, node, types, cursorTracer), factory);
    }

    public static <T> ResourceIterator<T> allIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory, PageCursorTracer cursorTracer) {
        return new RelationshipEntityIterator<T>(RelationshipSelections.allCursor(cursors, node, types, cursorTracer), factory);
    }

    private static class RelationshipEntityIterator<T>
    extends PrefetchingResourceIterator<T> {
        private final RelationshipTraversalCursor relationshipTraversalCursor;
        private final RelationshipFactory<T> factory;

        RelationshipEntityIterator(RelationshipTraversalCursor relationshipTraversalCursor, RelationshipFactory<T> factory) {
            this.relationshipTraversalCursor = relationshipTraversalCursor;
            this.factory = factory;
        }

        public void close() {
            this.relationshipTraversalCursor.close();
        }

        protected T fetchNextOrNull() {
            if (this.relationshipTraversalCursor.next()) {
                return this.factory.relationship(this.relationshipTraversalCursor.relationshipReference(), this.relationshipTraversalCursor.sourceNodeReference(), this.relationshipTraversalCursor.type(), this.relationshipTraversalCursor.targetNodeReference());
            }
            this.close();
            return null;
        }
    }
}

