/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;

public class IndexSamplingConfig {
    private final int sampleSizeLimit;
    private final double updateRatio;
    private final boolean backgroundSampling;

    public IndexSamplingConfig(Config config) {
        this((Integer)config.get(GraphDatabaseSettings.index_sample_size_limit), (double)((Integer)config.get(GraphDatabaseSettings.index_sampling_update_percentage)).intValue() / 100.0, (Boolean)config.get(GraphDatabaseSettings.index_background_sampling_enabled));
    }

    public IndexSamplingConfig(int sampleSizeLimit, double updateRatio, boolean backgroundSampling) {
        this.sampleSizeLimit = sampleSizeLimit;
        this.updateRatio = updateRatio;
        this.backgroundSampling = backgroundSampling;
    }

    public int sampleSizeLimit() {
        return this.sampleSizeLimit;
    }

    public double updateRatio() {
        return this.updateRatio;
    }

    public boolean backgroundSampling() {
        return this.backgroundSampling;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSamplingConfig that = (IndexSamplingConfig)o;
        return this.backgroundSampling == that.backgroundSampling && this.sampleSizeLimit == that.sampleSizeLimit && Double.compare(that.updateRatio, this.updateRatio) == 0;
    }

    public int hashCode() {
        int result = this.sampleSizeLimit;
        long temp = Double.doubleToLongBits(this.updateRatio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.backgroundSampling ? 1 : 0);
        return result;
    }
}

