/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Collections;
import java.util.Set;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;

public class SecurityContext
implements LoginContext {
    protected final AuthSubject subject;
    protected final AccessMode mode;
    public static final SecurityContext AUTH_DISABLED = new AuthDisabled(AccessMode.Static.FULL);

    public SecurityContext(AuthSubject subject, AccessMode mode) {
        this.subject = subject;
        this.mode = mode;
    }

    public AccessMode mode() {
        return this.mode;
    }

    public boolean isAdmin() {
        return true;
    }

    public boolean allowsAdminAction(AdminActionOnResource action) {
        this.assertCredentialsNotExpired();
        return true;
    }

    public Set<String> roles() {
        return Collections.emptySet();
    }

    @Override
    public AuthSubject subject() {
        return this.subject;
    }

    @Override
    public SecurityContext authorize(LoginContext.IdLookup idLookup, String dbName) {
        return this;
    }

    public SecurityContext withMode(AccessMode mode) {
        return new SecurityContext(this.subject, mode);
    }

    public void assertCredentialsNotExpired() {
        if (AuthenticationResult.PASSWORD_CHANGE_REQUIRED.equals((Object)this.subject().getAuthenticationResult())) {
            throw this.mode().onViolation("Permission denied.");
        }
    }

    public String description() {
        return String.format("user '%s' with %s", this.subject().username(), this.mode().name());
    }

    protected String defaultString(String name) {
        return String.format("%s{ username=%s, accessMode=%s }", name, this.subject().username(), this.mode());
    }

    private static final class AuthDisabled
    extends SecurityContext {
        private AuthDisabled(AccessMode mode) {
            super(AuthSubject.AUTH_DISABLED, mode);
        }

        @Override
        public SecurityContext withMode(AccessMode mode) {
            return new AuthDisabled(mode);
        }

        @Override
        public String description() {
            return "AUTH_DISABLED with " + this.mode().name();
        }

        public String toString() {
            return this.defaultString("auth-disabled");
        }
    }
}

