/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class FieldSignature {
    private final String name;
    private final Neo4jTypes.AnyType type;
    private final DefaultParameterValue defaultValue;
    private final boolean deprecated;

    public static FieldSignature inputField(String name, Neo4jTypes.AnyType type) {
        return new FieldSignature(name, type, null, false);
    }

    public static FieldSignature inputField(String name, Neo4jTypes.AnyType type, DefaultParameterValue defaultValue) {
        return new FieldSignature(name, type, Objects.requireNonNull(defaultValue, "defaultValue"), false);
    }

    public static FieldSignature outputField(String name, Neo4jTypes.AnyType type) {
        return FieldSignature.outputField(name, type, false);
    }

    public static FieldSignature outputField(String name, Neo4jTypes.AnyType type, boolean deprecated) {
        return new FieldSignature(name, type, null, deprecated);
    }

    private FieldSignature(String name, Neo4jTypes.AnyType type, DefaultParameterValue defaultValue, boolean deprecated) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.defaultValue = defaultValue;
        this.deprecated = deprecated;
        if (defaultValue != null && !type.equals(defaultValue.neo4jType())) {
            throw new IllegalArgumentException(String.format("Default value does not have a valid type, field type was %s, but value type was %s.", type.toString(), defaultValue.neo4jType().toString()));
        }
    }

    public Object map(Object input) {
        return input;
    }

    public Object map(AnyValue input, ValueMapper<Object> mapper) {
        return input.map(mapper);
    }

    public String name() {
        return this.name;
    }

    public Neo4jTypes.AnyType neo4jType() {
        return this.type;
    }

    public Optional<DefaultParameterValue> defaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        if (this.defaultValue != null) {
            result.append(" = ").append(this.defaultValue.value());
        }
        return result.append(" :: ").append(this.type).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldSignature that = (FieldSignature)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && Objects.equals(this.defaultValue, that.defaultValue) && this.deprecated == that.deprecated;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

