/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.NoSuchElementException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelection;

public final class RelationshipSparseSelectionIterator<R>
extends RelationshipSparseSelection
implements ResourceIterator<R> {
    private final RelationshipFactory<R> factory;
    private long next;

    RelationshipSparseSelectionIterator(RelationshipFactory<R> factory) {
        this.factory = factory;
        this.next = -2L;
    }

    public boolean hasNext() {
        if (this.next == -2L) {
            long l = this.next = this.fetchNext() ? this.cursor.relationshipReference() : -1L;
        }
        if (this.next == -1L) {
            this.close();
            return false;
        }
        return true;
    }

    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        R current = this.factory.relationship(this.next, this.cursor.sourceNodeReference(), this.cursor.type(), this.cursor.targetNodeReference());
        if (!this.fetchNext()) {
            this.close();
            this.next = -1L;
        } else {
            this.next = this.cursor.relationshipReference();
        }
        return current;
    }

    public void close() {
        this.closeInternal();
    }
}

