/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

abstract class RelationshipDenseSelection
extends DefaultCloseListenable {
    protected RelationshipGroupCursor groupCursor;
    protected RelationshipTraversalCursor relationshipCursor;
    private int[] types;
    private Dir[] directions = new Dir[3];
    private int currentDirection;
    private int nDirections;
    private boolean onRelationship;
    private boolean onGroup;
    private int foundTypes;

    RelationshipDenseSelection() {
    }

    public final void outgoing(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor) {
        this.outgoing(groupCursor, relationshipCursor, null);
    }

    public final void outgoing(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.groupCursor = groupCursor;
        this.relationshipCursor = relationshipCursor;
        this.types = types;
        this.directions[0] = Dir.OUT;
        this.directions[1] = Dir.LOOP;
        this.nDirections = 2;
        this.currentDirection = this.directions.length;
        this.onRelationship = false;
        this.onGroup = false;
        this.foundTypes = 0;
    }

    public final void incoming(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor) {
        this.incoming(groupCursor, relationshipCursor, null);
    }

    public final void incoming(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.groupCursor = groupCursor;
        this.relationshipCursor = relationshipCursor;
        this.types = types;
        this.directions[0] = Dir.IN;
        this.directions[1] = Dir.LOOP;
        this.nDirections = 2;
        this.currentDirection = this.directions.length;
        this.onRelationship = false;
        this.onGroup = false;
        this.foundTypes = 0;
    }

    public final void all(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor) {
        this.all(groupCursor, relationshipCursor, null);
    }

    public final void all(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.groupCursor = groupCursor;
        this.relationshipCursor = relationshipCursor;
        this.types = types;
        this.directions[0] = Dir.OUT;
        this.directions[1] = Dir.IN;
        this.directions[2] = Dir.LOOP;
        this.nDirections = 3;
        this.currentDirection = this.directions.length;
        this.onRelationship = false;
        this.onGroup = false;
        this.foundTypes = 0;
    }

    protected boolean fetchNext() {
        if (this.onRelationship) {
            this.onRelationship = this.relationshipCursor.next();
        }
        while (!this.onRelationship) {
            ++this.currentDirection;
            if (this.currentDirection >= this.nDirections) {
                if (this.types != null && this.foundTypes >= this.types.length) {
                    this.onGroup = false;
                    return false;
                }
                this.loopOnRelationship();
            }
            if (!this.onGroup) {
                return false;
            }
            this.setupCursors();
        }
        return true;
    }

    private void loopOnRelationship() {
        do {
            this.onGroup = this.groupCursor.next();
        } while (this.onGroup && !this.correctRelationshipType());
        if (this.onGroup) {
            ++this.foundTypes;
            this.currentDirection = 0;
        }
    }

    private void setupCursors() {
        Dir d = this.directions[this.currentDirection];
        switch (d) {
            case OUT: {
                this.groupCursor.outgoing(this.relationshipCursor);
                this.onRelationship = this.relationshipCursor.next();
                break;
            }
            case IN: {
                this.groupCursor.incoming(this.relationshipCursor);
                this.onRelationship = this.relationshipCursor.next();
                break;
            }
            case LOOP: {
                this.groupCursor.loops(this.relationshipCursor);
                this.onRelationship = this.relationshipCursor.next();
                break;
            }
            default: {
                throw new IllegalStateException("Lorem ipsus, Brutus. (could not setup cursor for Dir='" + d + "')");
            }
        }
    }

    private boolean correctRelationshipType() {
        return this.types == null || ArrayUtils.contains((int[])this.types, (int)this.groupCursor.type());
    }

    public void closeInternal() {
        Throwable closeGroupError = null;
        try {
            if (this.groupCursor != null) {
                this.groupCursor.close();
            }
        }
        catch (Throwable t) {
            closeGroupError = t;
        }
        try {
            if (this.relationshipCursor != null) {
                this.relationshipCursor.close();
            }
        }
        catch (Throwable t) {
            if (closeGroupError != null) {
                t.addSuppressed(closeGroupError);
            }
            throw t;
        }
        finally {
            this.relationshipCursor = null;
            this.groupCursor = null;
        }
    }

    private static enum Dir {
        OUT,
        IN,
        LOOP;

    }
}

