/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.neo4j.internal.kernel.api.NumberRangePredicate;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public abstract class IndexQuery {
    private final int propertyKeyId;

    public static ExistsPredicate exists(int propertyKeyId) {
        return new ExistsPredicate(propertyKeyId);
    }

    public static ExactPredicate exact(int propertyKeyId, Object value) {
        return new ExactPredicate(propertyKeyId, value);
    }

    public static RangePredicate<?> range(int propertyKeyId, Number from, boolean fromInclusive, Number to, boolean toInclusive) {
        return NumberRangePredicate.create(propertyKeyId, from == null ? null : Values.numberValue((Number)from), fromInclusive, to == null ? null : Values.numberValue((Number)to), toInclusive);
    }

    public static RangePredicate<?> range(int propertyKeyId, String from, boolean fromInclusive, String to, boolean toInclusive) {
        return new TextRangePredicate(propertyKeyId, from == null ? null : Values.stringValue((String)from), fromInclusive, to == null ? null : Values.stringValue((String)to), toInclusive);
    }

    public static <VALUE extends Value> RangePredicate<?> range(int propertyKeyId, VALUE from, boolean fromInclusive, VALUE to, boolean toInclusive) {
        if (from == null && to == null) {
            throw new IllegalArgumentException("Cannot create RangePredicate without at least one bound");
        }
        ValueGroup valueGroup = from != null ? from.valueGroup() : to.valueGroup();
        switch (valueGroup) {
            case NUMBER: {
                return NumberRangePredicate.create(propertyKeyId, (NumberValue)from, fromInclusive, (NumberValue)to, toInclusive);
            }
            case TEXT: {
                return new TextRangePredicate(propertyKeyId, (TextValue)from, fromInclusive, (TextValue)to, toInclusive);
            }
            case GEOMETRY: {
                PointValue pFrom = (PointValue)from;
                PointValue pTo = (PointValue)to;
                CoordinateReferenceSystem crs = pFrom != null ? pFrom.getCoordinateReferenceSystem() : pTo.getCoordinateReferenceSystem();
                return new GeometryRangePredicate(propertyKeyId, crs, pFrom, fromInclusive, pTo, toInclusive);
            }
        }
        return new RangePredicate<VALUE>(propertyKeyId, valueGroup, from, fromInclusive, to, toInclusive);
    }

    public static RangePredicate<?> range(int propertyKeyId, ValueGroup valueGroup) {
        if (valueGroup == ValueGroup.GEOMETRY) {
            throw new IllegalArgumentException("Cannot create GeometryRangePredicate without a specified CRS");
        }
        return new RangePredicate<Object>(propertyKeyId, valueGroup, null, true, null, true);
    }

    public static RangePredicate<?> range(int propertyKeyId, CoordinateReferenceSystem crs) {
        return new GeometryRangePredicate(propertyKeyId, crs, null, true, null, true);
    }

    public static StringPrefixPredicate stringPrefix(int propertyKeyId, TextValue prefix) {
        return new StringPrefixPredicate(propertyKeyId, prefix);
    }

    public static StringContainsPredicate stringContains(int propertyKeyId, TextValue contains) {
        return new StringContainsPredicate(propertyKeyId, contains);
    }

    public static StringSuffixPredicate stringSuffix(int propertyKeyId, TextValue suffix) {
        return new StringSuffixPredicate(propertyKeyId, suffix);
    }

    public static IndexQuery fulltextSearch(String query) {
        return new FulltextSearchPredicate(query);
    }

    public static ValueTuple asValueTuple(ExactPredicate ... query) {
        Value[] values = new Value[query.length];
        for (int i = 0; i < query.length; ++i) {
            values[i] = query[i].value();
        }
        return ValueTuple.of((Value[])values);
    }

    protected IndexQuery(int propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    public abstract IndexQueryType type();

    public final boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public final int propertyKeyId() {
        return this.propertyKeyId;
    }

    public abstract boolean acceptsValue(Value var1);

    public boolean acceptsValueAt(PropertyCursor property) {
        return this.acceptsValue(property.propertyValue());
    }

    public abstract ValueGroup valueGroup();

    public ValueCategory valueCategory() {
        return this.valueGroup().category();
    }

    public static final class FulltextSearchPredicate
    extends StringPredicate {
        private final String query;

        private FulltextSearchPredicate(String query) {
            super(-1);
            this.query = query;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.fulltextSearch;
        }

        @Override
        public boolean acceptsValue(Value value) {
            throw new UnsupportedOperationException("Fulltext search predicates do not know how to evaluate themselves.");
        }

        public String query() {
            return this.query;
        }
    }

    public static final class StringSuffixPredicate
    extends StringPredicate {
        private final TextValue suffix;

        private StringSuffixPredicate(int propertyKeyId, TextValue suffix) {
            super(propertyKeyId);
            this.suffix = this.asUTF8StringValue(suffix);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringSuffix;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return Values.isTextValue((Object)value) && ((TextValue)value).endsWith(this.suffix);
        }

        public TextValue suffix() {
            return this.suffix;
        }
    }

    public static final class StringContainsPredicate
    extends StringPredicate {
        private final TextValue contains;

        private StringContainsPredicate(int propertyKeyId, TextValue contains) {
            super(propertyKeyId);
            this.contains = this.asUTF8StringValue(contains);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringContains;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return Values.isTextValue((Object)value) && ((TextValue)value).contains(this.contains);
        }

        public TextValue contains() {
            return this.contains;
        }
    }

    public static final class StringPrefixPredicate
    extends StringPredicate {
        private final TextValue prefix;

        private StringPrefixPredicate(int propertyKeyId, TextValue prefix) {
            super(propertyKeyId);
            this.prefix = this.asUTF8StringValue(prefix);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringPrefix;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return Values.isTextValue((Object)value) && ((TextValue)value).startsWith(this.prefix);
        }

        public TextValue prefix() {
            return this.prefix;
        }
    }

    public static abstract class StringPredicate
    extends IndexQuery {
        private StringPredicate(int propertyKeyId) {
            super(propertyKeyId);
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.TEXT;
        }

        protected TextValue asUTF8StringValue(TextValue in) {
            if (in instanceof UTF8StringValue) {
                return in;
            }
            return Values.utf8Value((byte[])in.stringValue().getBytes(StandardCharsets.UTF_8));
        }
    }

    public static final class TextRangePredicate
    extends RangePredicate<TextValue> {
        private TextRangePredicate(int propertyKeyId, TextValue from, boolean fromInclusive, TextValue to, boolean toInclusive) {
            super(propertyKeyId, ValueGroup.TEXT, from, fromInclusive, to, toInclusive);
        }

        public String from() {
            return this.from == null ? null : ((TextValue)this.from).stringValue();
        }

        public String to() {
            return this.to == null ? null : ((TextValue)this.to).stringValue();
        }
    }

    public static final class GeometryRangePredicate
    extends RangePredicate<PointValue> {
        private final CoordinateReferenceSystem crs;

        private GeometryRangePredicate(int propertyKeyId, CoordinateReferenceSystem crs, PointValue from, boolean fromInclusive, PointValue to, boolean toInclusive) {
            super(propertyKeyId, ValueGroup.GEOMETRY, from, fromInclusive, to, toInclusive);
            this.crs = crs;
        }

        @Override
        public boolean acceptsValue(Value value) {
            PointValue point;
            if (value == null) {
                return false;
            }
            if (value instanceof PointValue && (point = (PointValue)value).getCoordinateReferenceSystem().equals((Object)this.crs)) {
                Boolean within = point.withinRange((PointValue)this.from, this.fromInclusive, (PointValue)this.to, this.toInclusive);
                return within == null ? false : within;
            }
            return false;
        }

        public CoordinateReferenceSystem crs() {
            return this.crs;
        }

        public PointValue from() {
            return (PointValue)this.from;
        }

        public PointValue to() {
            return (PointValue)this.to;
        }

        @Override
        public boolean isRegularOrder() {
            return false;
        }
    }

    public static class RangePredicate<T extends Value>
    extends IndexQuery {
        protected final T from;
        protected final boolean fromInclusive;
        protected final T to;
        protected final boolean toInclusive;
        protected final ValueGroup valueGroup;

        RangePredicate(int propertyKeyId, ValueGroup valueGroup, T from, boolean fromInclusive, T to, boolean toInclusive) {
            super(propertyKeyId);
            this.valueGroup = valueGroup;
            this.from = from;
            this.fromInclusive = fromInclusive;
            this.to = to;
            this.toInclusive = toInclusive;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.range;
        }

        @Override
        public boolean acceptsValue(Value value) {
            if (value == null || value == Values.NO_VALUE) {
                return false;
            }
            if (value.valueGroup() == this.valueGroup) {
                int compare;
                if (this.from != null && ((compare = Values.COMPARATOR.compare(value, this.from)) < 0 || !this.fromInclusive && compare == 0)) {
                    return false;
                }
                if (this.to != null) {
                    compare = Values.COMPARATOR.compare(value, this.to);
                    return compare <= 0 && (this.toInclusive || compare != 0);
                }
                return true;
            }
            return false;
        }

        @Override
        public ValueGroup valueGroup() {
            return this.valueGroup;
        }

        public Value fromValue() {
            return this.from == null ? Values.NO_VALUE : this.from;
        }

        public Value toValue() {
            return this.to == null ? Values.NO_VALUE : this.to;
        }

        public boolean fromInclusive() {
            return this.fromInclusive;
        }

        public boolean toInclusive() {
            return this.toInclusive;
        }

        public boolean isRegularOrder() {
            return true;
        }
    }

    public static final class ExactPredicate
    extends IndexQuery {
        private final Value exactValue;

        private ExactPredicate(int propertyKeyId, Object value) {
            super(propertyKeyId);
            this.exactValue = value instanceof Value ? (Value)value : Values.of((Object)value);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.exact;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return this.exactValue.equals(value);
        }

        @Override
        public ValueGroup valueGroup() {
            return this.exactValue.valueGroup();
        }

        public Value value() {
            return this.exactValue;
        }
    }

    public static final class ExistsPredicate
    extends IndexQuery {
        private ExistsPredicate(int propertyKeyId) {
            super(propertyKeyId);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.exists;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return value != null && value != Values.NO_VALUE;
        }

        @Override
        public boolean acceptsValueAt(PropertyCursor property) {
            return true;
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.UNKNOWN;
        }
    }

    public static enum IndexQueryType {
        exists,
        exact,
        range,
        stringPrefix,
        stringSuffix,
        stringContains,
        fulltextSearch;

    }
}

