/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.NodeValueIndexProgressor;

public abstract class AbstractIndexReader
implements IndexReader {
    protected final IndexDescriptor descriptor;

    protected AbstractIndexReader(IndexDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void query(IndexProgressor.NodeValueClient client, IndexOrder indexOrder, boolean needsValues, IndexQuery ... query) throws IndexNotApplicableKernelException {
        if (indexOrder != IndexOrder.NONE) {
            throw new UnsupportedOperationException(String.format("This reader only have support for index order %s. Provided index order was %s.", new Object[]{IndexOrder.NONE, indexOrder}));
        }
        client.initialize(this.descriptor, new NodeValueIndexProgressor(this.query(query), client), query, needsValues);
    }
}

