/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.schema;

import java.util.function.Predicate;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.storageengine.api.lock.ResourceType;

public interface SchemaDescriptor
extends SchemaDescriptorSupplier {
    public <R> R computeWith(SchemaComputer<R> var1);

    public void processWith(SchemaProcessor var1);

    public String userDescription(TokenNameLookup var1);

    public String keyName(TokenNameLookup var1);

    public int[] getPropertyIds();

    default public int getPropertyId() {
        int[] propertyIds = this.getPropertyIds();
        if (propertyIds.length != 1) {
            throw new IllegalStateException("Single property schema requires one property but had " + propertyIds.length);
        }
        return propertyIds[0];
    }

    public int keyId();

    public ResourceType keyType();

    public static <T extends SchemaDescriptorSupplier> Predicate<T> equalTo(SchemaDescriptor descriptor) {
        return supplier -> descriptor.equals(supplier.schema());
    }

    public static interface Supplier {
        public SchemaDescriptor schema();
    }
}

