/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;

public class SecurityContext
implements LoginContext {
    protected final AuthSubject subject;
    protected final AccessMode mode;
    public static final SecurityContext AUTH_DISABLED = SecurityContext.authDisabled(AccessMode.Static.FULL);

    public SecurityContext(AuthSubject subject, AccessMode mode) {
        this.subject = subject;
        this.mode = mode;
    }

    public AccessMode mode() {
        return this.mode;
    }

    public boolean isAdmin() {
        return true;
    }

    @Override
    public AuthSubject subject() {
        return this.subject;
    }

    @Override
    public SecurityContext authorize(Token token) {
        return this;
    }

    public SecurityContext withMode(AccessMode mode) {
        return new SecurityContext(this.subject, mode);
    }

    public void assertCredentialsNotExpired() {
        if (this.subject().getAuthenticationResult().equals((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED)) {
            throw this.mode().onViolation("Permission denied.");
        }
    }

    public String description() {
        return String.format("user '%s' with %s", this.subject().username(), this.mode().name());
    }

    protected String defaultString(String name) {
        return String.format("%s{ username=%s, accessMode=%s }", name, this.subject().username(), this.mode());
    }

    private static SecurityContext authDisabled(AccessMode mode) {
        return new SecurityContext(AuthSubject.AUTH_DISABLED, mode){

            @Override
            public SecurityContext withMode(AccessMode mode) {
                return SecurityContext.authDisabled(mode);
            }

            @Override
            public String description() {
                return "AUTH_DISABLED with " + this.mode().name();
            }

            public String toString() {
                return this.defaultString("auth-disabled");
            }
        };
    }
}

