/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelectionIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelectionIterator;

public final class RelationshipSelections {
    private RelationshipSelections() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static RelationshipSelectionCursor outgoingCursor(CursorFactory cursors, NodeCursor node, int[] types) {
        if (node.isDense()) {
            RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
            RelationshipSelections.setupOutgoingDense(selectionCursor, cursors, node, types);
            return selectionCursor;
        }
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        RelationshipSelections.setupOutgoingSparse(selectionCursor, cursors, node, types);
        return selectionCursor;
    }

    public static RelationshipSelectionCursor incomingCursor(CursorFactory cursors, NodeCursor node, int[] types) {
        if (node.isDense()) {
            RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
            RelationshipSelections.setupIncomingDense(selectionCursor, cursors, node, types);
            return selectionCursor;
        }
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        RelationshipSelections.setupIncomingSparse(selectionCursor, cursors, node, types);
        return selectionCursor;
    }

    public static RelationshipSelectionCursor allCursor(CursorFactory cursors, NodeCursor node, int[] types) {
        if (node.isDense()) {
            RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
            RelationshipSelections.setupAllDense(selectionCursor, cursors, node, types);
            return selectionCursor;
        }
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        RelationshipSelections.setupAllSparse(selectionCursor, cursors, node, types);
        return selectionCursor;
    }

    public static <T> ResourceIterator<T> outgoingIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipSelections.setupOutgoingDense(selectionIterator, cursors, node, types);
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipSelections.setupOutgoingSparse(selectionIterator, cursors, node, types);
        return selectionIterator;
    }

    public static <T> ResourceIterator<T> incomingIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipSelections.setupIncomingDense(selectionIterator, cursors, node, types);
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipSelections.setupIncomingSparse(selectionIterator, cursors, node, types);
        return selectionIterator;
    }

    public static <T> ResourceIterator<T> allIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipSelections.setupAllDense(selectionIterator, cursors, node, types);
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipSelections.setupAllSparse(selectionIterator, cursors, node, types);
        return selectionIterator;
    }

    private static void setupOutgoingDense(RelationshipDenseSelection denseSelection, CursorFactory cursors, NodeCursor node, int[] types) {
        RelationshipGroupCursor groupCursor = cursors.allocateRelationshipGroupCursor();
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.relationships(groupCursor);
            denseSelection.outgoing(groupCursor, traversalCursor, types);
        }
        catch (Throwable t) {
            groupCursor.close();
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupIncomingDense(RelationshipDenseSelection denseSelection, CursorFactory cursors, NodeCursor node, int[] types) {
        RelationshipGroupCursor groupCursor = cursors.allocateRelationshipGroupCursor();
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.relationships(groupCursor);
            denseSelection.incoming(groupCursor, traversalCursor, types);
        }
        catch (Throwable t) {
            groupCursor.close();
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupAllDense(RelationshipDenseSelection denseSelection, CursorFactory cursors, NodeCursor node, int[] types) {
        RelationshipGroupCursor groupCursor = cursors.allocateRelationshipGroupCursor();
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.relationships(groupCursor);
            denseSelection.all(groupCursor, traversalCursor, types);
        }
        catch (Throwable t) {
            groupCursor.close();
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupOutgoingSparse(RelationshipSparseSelection sparseSelection, CursorFactory cursors, NodeCursor node, int[] types) {
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.allRelationships(traversalCursor);
            sparseSelection.outgoing(traversalCursor, types);
        }
        catch (Throwable t) {
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupIncomingSparse(RelationshipSparseSelection sparseSelection, CursorFactory cursors, NodeCursor node, int[] types) {
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.allRelationships(traversalCursor);
            sparseSelection.incoming(traversalCursor, types);
        }
        catch (Throwable t) {
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupAllSparse(RelationshipSparseSelection sparseSelection, CursorFactory cursors, NodeCursor node, int[] types) {
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.allRelationships(traversalCursor);
            sparseSelection.all(traversalCursor, types);
        }
        catch (Throwable t) {
            traversalCursor.close();
            throw t;
        }
    }
}

