/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.NoSuchElementException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;

public final class RelationshipDenseSelectionIterator<R>
extends RelationshipDenseSelection
implements ResourceIterator<R> {
    private RelationshipFactory<R> factory;
    private R _next;
    private boolean initialized;

    public RelationshipDenseSelectionIterator(RelationshipFactory<R> factory) {
        this.factory = factory;
        this.initialized = false;
    }

    public boolean hasNext() {
        if (!this.initialized) {
            this.fetchNext();
            this.initialized = true;
        }
        if (this._next == null) {
            this.close();
            return false;
        }
        return true;
    }

    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        R current = this._next;
        if (!this.fetchNext()) {
            this._next = null;
        }
        return current;
    }

    @Override
    protected void setRelationship(long id, long sourceNode, int type, long targetNode) {
        this._next = this.factory.relationship(id, sourceNode, type, targetNode);
    }
}

