/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate.memory;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.memory.TxStateMemoryConsumer;

public class MultiVersionTxStateMemoryConsumer
implements TxStateMemoryConsumer {
    private final Config config;
    private long consumptionSize;

    public MultiVersionTxStateMemoryConsumer(Config config) {
        this.config = config;
    }

    @Override
    public void initialize() {
        this.consumptionSize = (Long)this.config.get(GraphDatabaseInternalSettings.multi_version_deletion_additional_reservation_size);
    }

    @Override
    public void consume(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(this.consumptionSize);
    }
}

