/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.traversal;

import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.graphdb.traversal.TraversalBranch;

class BidirectionalTraversalBranchPath
implements Path {
    private final TraversalBranch start;
    private final TraversalBranch end;
    private final Node endNode;
    private final Relationship lastRelationship;
    private Node cachedStartNode;
    private LinkedList<Relationship> cachedRelationships;

    BidirectionalTraversalBranchPath(TraversalBranch start, TraversalBranch end) {
        this.start = start;
        this.end = end;
        Iterator<PropertyContainer> endPathEntities = end.iterator();
        this.endNode = (Node)endPathEntities.next();
        this.lastRelationship = endPathEntities.hasNext() ? (Relationship)endPathEntities.next() : start.lastRelationship();
    }

    @Override
    public Node startNode() {
        if (this.cachedStartNode == null) {
            this.cachedStartNode = this.start.startNode();
        }
        return this.cachedStartNode;
    }

    @Override
    public Node endNode() {
        return this.endNode;
    }

    @Override
    public Relationship lastRelationship() {
        return this.lastRelationship;
    }

    @Override
    public Iterable<Relationship> relationships() {
        if (this.cachedRelationships == null) {
            this.cachedRelationships = this.gatherRelationships(this.start, this.end);
        }
        return this.cachedRelationships;
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        return this.gatherRelationships(this.end, this.start);
    }

    private LinkedList<Relationship> gatherRelationships(TraversalBranch first, TraversalBranch then) {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        TraversalBranch branch = first;
        while (branch.length() > 0) {
            relationships.addFirst(branch.lastRelationship());
            branch = branch.parent();
        }
        if (this.cachedStartNode == null && first == this.start && branch.length() >= 0) {
            this.cachedStartNode = branch.endNode();
        }
        branch = then;
        while (branch.length() > 0) {
            relationships.add(branch.lastRelationship());
            branch = branch.parent();
        }
        if (this.cachedStartNode == null && then == this.start && branch.length() >= 0) {
            this.cachedStartNode = branch.endNode();
        }
        return relationships;
    }

    @Override
    public Iterable<Node> nodes() {
        return this.gatherNodes(this.start, this.end);
    }

    @Override
    public Iterable<Node> reverseNodes() {
        return this.gatherNodes(this.end, this.start);
    }

    private Iterable<Node> gatherNodes(TraversalBranch first, TraversalBranch then) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        TraversalBranch branch = first;
        while (branch.length() > 0) {
            nodes.addFirst(branch.endNode());
            branch = branch.parent();
        }
        if (this.cachedStartNode == null && first == this.start && branch.length() >= 0) {
            this.cachedStartNode = branch.endNode();
        }
        nodes.addFirst(branch.endNode());
        branch = then.parent();
        if (branch != null) {
            while (branch.length() > 0) {
                nodes.add(branch.endNode());
                branch = branch.parent();
            }
            if (branch.length() >= 0) {
                nodes.add(branch.endNode());
            }
        }
        if (this.cachedStartNode == null && then == this.start && branch.length() >= 0) {
            this.cachedStartNode = branch.endNode();
        }
        return nodes;
    }

    @Override
    public int length() {
        return this.start.length() + this.end.length();
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        LinkedList<Entity> entities = new LinkedList<Entity>();
        TraversalBranch branch = this.start;
        while (branch.length() > 0) {
            entities.addFirst(branch.endNode());
            entities.addFirst(branch.lastRelationship());
            branch = branch.parent();
        }
        entities.addFirst(branch.endNode());
        if (this.cachedStartNode == null) {
            this.cachedStartNode = branch.endNode();
        }
        if (this.end.length() > 0) {
            entities.add(this.end.lastRelationship());
            branch = this.end.parent();
            while (branch.length() > 0) {
                entities.add(branch.endNode());
                entities.add(branch.lastRelationship());
                branch = branch.parent();
            }
            entities.add(branch.endNode());
        }
        return entities.iterator();
    }

    public int hashCode() {
        return this.relationships().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path other = (Path)obj;
        return this.relationships().equals(other.relationships()) && other.startNode().equals(this.cachedStartNode);
    }

    @Override
    public String toString() {
        return Paths.defaultPathToString(this);
    }
}

