/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Arrays;
import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.ExpressionTemplate;
import org.neo4j.codegen.ExpressionToString;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;
import org.neo4j.values.AnyValue;

public abstract class Expression
extends ExpressionTemplate {
    public static final Expression TRUE = new Constant(TypeReference.BOOLEAN, Boolean.TRUE){

        @Override
        Expression not() {
            return FALSE;
        }
    };
    public static final Expression FALSE = new Constant(TypeReference.BOOLEAN, Boolean.FALSE){

        @Override
        Expression not() {
            return TRUE;
        }
    };
    public static final Expression NULL = new Constant(TypeReference.OBJECT, null);
    static final Expression SUPER = new Expression(TypeReference.OBJECT){

        @Override
        public void accept(ExpressionVisitor visitor) {
            visitor.loadThis("super");
        }
    };
    public static final Expression EMPTY = new Expression(TypeReference.VOID){

        @Override
        public void accept(ExpressionVisitor visitor) {
        }
    };

    protected Expression(TypeReference type) {
        super(type);
    }

    public abstract void accept(ExpressionVisitor var1);

    public static Expression gt(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.gt(lhs, rhs);
            }

            @Override
            Expression not() {
                return 5.lte(lhs, rhs);
            }
        };
    }

    public static Expression gte(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.gte(lhs, rhs);
            }

            @Override
            Expression not() {
                return 6.lt(lhs, rhs);
            }
        };
    }

    public static Expression lt(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.lt(lhs, rhs);
            }

            @Override
            Expression not() {
                return 7.gte(lhs, rhs);
            }
        };
    }

    public static Expression lte(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.lte(lhs, rhs);
            }

            @Override
            Expression not() {
                return 8.gt(lhs, rhs);
            }
        };
    }

    public static Expression and(Expression lhs, Expression rhs) {
        if (lhs == FALSE || rhs == FALSE) {
            return FALSE;
        }
        if (lhs == TRUE) {
            return rhs;
        }
        if (rhs == TRUE) {
            return lhs;
        }
        Expression[] expressions = lhs instanceof And ? (rhs instanceof And ? Expression.expressions(((And)lhs).expressions, ((And)rhs).expressions) : Expression.expressions(((And)lhs).expressions, rhs)) : (rhs instanceof And ? Expression.expressions(lhs, ((And)rhs).expressions) : new Expression[]{lhs, rhs});
        return new And(expressions);
    }

    public static Expression or(Expression lhs, Expression rhs) {
        if (lhs == TRUE || rhs == TRUE) {
            return TRUE;
        }
        if (lhs == FALSE) {
            return rhs;
        }
        if (rhs == FALSE) {
            return lhs;
        }
        Expression[] expressions = lhs instanceof Or ? (rhs instanceof Or ? Expression.expressions(((Or)lhs).expressions, ((Or)rhs).expressions) : Expression.expressions(((Or)lhs).expressions, rhs)) : (rhs instanceof Or ? Expression.expressions(lhs, ((Or)rhs).expressions) : new Expression[]{lhs, rhs});
        return new Or(expressions);
    }

    private static Expression[] expressions(Expression[] some, Expression[] more) {
        Expression[] result = Arrays.copyOf(some, some.length + more.length);
        System.arraycopy(more, 0, result, some.length, more.length);
        return result;
    }

    private static Expression[] expressions(Expression[] some, Expression last) {
        Expression[] result = Arrays.copyOf(some, some.length + 1);
        result[some.length] = last;
        return result;
    }

    private static Expression[] expressions(Expression first, Expression[] more) {
        Expression[] result = new Expression[more.length + 1];
        result[0] = first;
        System.arraycopy(more, 0, result, 1, more.length);
        return result;
    }

    public static Expression equal(final Expression lhs, final Expression rhs) {
        if (lhs == NULL) {
            if (rhs == NULL) {
                return Expression.constant(Boolean.TRUE);
            }
            return Expression.isNull(rhs);
        }
        if (rhs == NULL) {
            return Expression.isNull(lhs);
        }
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.equal(lhs, rhs);
            }

            @Override
            Expression not() {
                return 9.notEqual(lhs, rhs);
            }
        };
    }

    public static Expression isNull(final Expression expression) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.isNull(expression);
            }

            @Override
            Expression not() {
                return 10.notNull(expression);
            }
        };
    }

    public static Expression notNull(final Expression expression) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.notNull(expression);
            }

            @Override
            Expression not() {
                return 11.isNull(expression);
            }
        };
    }

    public static Expression notEqual(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.notEqual(lhs, rhs);
            }

            @Override
            Expression not() {
                return 12.equal(lhs, rhs);
            }
        };
    }

    public static Expression load(final LocalVariable variable) {
        return new Expression(variable.type()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.load(variable);
            }
        };
    }

    public static Expression arrayLoad(final Expression array, final Expression index) {
        assert (array.type().isArray());
        return new Expression(array.type()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.arrayLoad(array, index);
            }
        };
    }

    public static Expression arrayLength(final Expression array) {
        assert (array.type().isArray());
        return new Expression(TypeReference.INT){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.arrayLength(array);
            }
        };
    }

    public static Expression arraySet(final Expression array, final Expression index, final Expression value) {
        assert (array.type().isArray());
        return new Expression(array.type()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.arraySet(array, index, value);
            }
        };
    }

    public static Expression add(final Expression lhs, final Expression rhs) {
        if (!lhs.type.equals(rhs.type)) {
            throw new IllegalArgumentException(String.format("Cannot add variables with different types. LHS %s, RHS %s", lhs.type.simpleName(), rhs.type.simpleName()));
        }
        return new Expression(lhs.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.add(lhs, rhs);
            }
        };
    }

    public static Expression subtract(final Expression lhs, final Expression rhs) {
        if (!lhs.type.equals(rhs.type)) {
            throw new IllegalArgumentException(String.format("Cannot subtract variables with different types. LHS %s, RHS %s", lhs.type.simpleName(), rhs.type.simpleName()));
        }
        return new Expression(lhs.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.subtract(lhs, rhs);
            }
        };
    }

    public static Expression multiply(final Expression lhs, final Expression rhs) {
        if (!lhs.type.equals(rhs.type)) {
            throw new IllegalArgumentException(String.format("Cannot multiply variables with different types. LHS %s, RHS %s", lhs.type.simpleName(), rhs.type.simpleName()));
        }
        return new Expression(lhs.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.multiply(lhs, rhs);
            }
        };
    }

    public static Expression constantInt(int value) {
        return Expression.constant(value);
    }

    public static Expression constantLong(long value) {
        return Expression.constant(value);
    }

    public static Expression constant(final Object value) {
        TypeReference reference;
        if (value == null) {
            return NULL;
        }
        if (value instanceof String) {
            reference = TypeReference.typeReference(String.class);
        } else if (value instanceof Long) {
            reference = TypeReference.LONG;
        } else if (value instanceof Integer) {
            reference = TypeReference.INT;
        } else if (value instanceof Double) {
            reference = TypeReference.DOUBLE;
        } else {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? TRUE : FALSE;
            }
            if (value instanceof AnyValue) {
                reference = TypeReference.VALUE;
            } else {
                throw new IllegalArgumentException("Not a valid constant: " + value);
            }
        }
        return new Expression(reference){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.constant(value);
            }
        };
    }

    public static Expression newArray(final TypeReference baseType, final int size) {
        return new Expression(TypeReference.arrayOf(baseType)){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.newArray(baseType, size);
            }
        };
    }

    public static Expression newInitializedArray(final TypeReference baseType, final Expression ... constants) {
        return new Expression(TypeReference.arrayOf(baseType)){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.newInitializedArray(baseType, constants);
            }
        };
    }

    public static Expression get(final Expression target, final FieldReference field) {
        return new Expression(field.type()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.getField(target, field);
            }
        };
    }

    public static Expression box(final Expression expression) {
        return new Expression(TypeReference.toBoxedType(expression.type)){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.box(expression);
            }
        };
    }

    public static Expression unbox(final Expression expression) {
        TypeReference type;
        switch (expression.type.fullName()) {
            case "java.lang.Byte": {
                type = TypeReference.typeReference(Byte.TYPE);
                break;
            }
            case "java.lang.Short": {
                type = TypeReference.typeReference(Short.TYPE);
                break;
            }
            case "java.lang.Integer": {
                type = TypeReference.typeReference(Integer.TYPE);
                break;
            }
            case "java.lang.Long": {
                type = TypeReference.typeReference(Long.TYPE);
                break;
            }
            case "java.lang.Character": {
                type = TypeReference.typeReference(Character.TYPE);
                break;
            }
            case "java.lang.Boolean": {
                type = TypeReference.typeReference(Boolean.TYPE);
                break;
            }
            case "java.lang.Float": {
                type = TypeReference.typeReference(Float.TYPE);
                break;
            }
            case "java.lang.Double": {
                type = TypeReference.typeReference(Double.TYPE);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot unbox " + expression.type.fullName());
            }
        }
        return new Expression(type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.unbox(expression);
            }
        };
    }

    public static Expression getStatic(final FieldReference field) {
        return new Expression(field.type()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.getStatic(field);
            }
        };
    }

    public static Expression ternary(final Expression test, final Expression onTrue, final Expression onFalse) {
        TypeReference reference = onTrue.type.equals(onFalse.type) ? onTrue.type : TypeReference.OBJECT;
        return new Expression(reference){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.ternary(test, onTrue, onFalse);
            }
        };
    }

    public static Expression invoke(final Expression target, final MethodReference method, final Expression ... arguments) {
        return new Expression(method.returns()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.invoke(target, method, arguments);
            }
        };
    }

    public static Expression invoke(final MethodReference method, final Expression ... parameters) {
        return new Expression(method.returns()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.invoke(method, parameters);
            }
        };
    }

    public static Expression invokeSuper(final TypeReference parent, final Expression ... parameters) {
        final TypeReference[] parameterTypes = (TypeReference[])Arrays.stream(parameters).map(ExpressionTemplate::type).toArray(TypeReference[]::new);
        return new Expression(TypeReference.OBJECT){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.invoke(SUPER, new MethodReference(parent, "<init>", TypeReference.VOID, 1, parameterTypes), parameters);
            }
        };
    }

    public static Expression cast(Class<?> type, Expression expression) {
        return Expression.cast(TypeReference.typeReference(type), expression);
    }

    public static Expression instanceOf(final TypeReference typeToCheck, final Expression expression) {
        return new Expression(TypeReference.typeReference(Boolean.TYPE)){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.instanceOf(typeToCheck, expression);
            }
        };
    }

    public static Expression cast(TypeReference type, final Expression expression) {
        return new Expression(type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.cast(this.type, expression);
            }
        };
    }

    public static Expression newInstance(Class<?> type) {
        return Expression.newInstance(TypeReference.typeReference(type));
    }

    public static Expression newInstance(TypeReference type) {
        return new Expression(type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.newInstance(this.type);
            }
        };
    }

    public static Expression not(Expression expression) {
        return expression.not();
    }

    Expression not() {
        return Expression.notExpr(this);
    }

    private static Expression notExpr(final Expression expression) {
        assert (expression.type.equals(TypeReference.BOOLEAN)) : "Can only apply not() to boolean expressions";
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.not(expression);
            }

            @Override
            Expression not() {
                return expression;
            }
        };
    }

    public static Expression toDouble(final Expression expression) {
        return new Expression(TypeReference.DOUBLE){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.longToDouble(expression);
            }
        };
    }

    public static Expression pop(final Expression expression) {
        return new Expression(expression.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.pop(expression);
            }
        };
    }

    @Override
    Expression materialize(CodeBlock method) {
        return this;
    }

    @Override
    void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
        throw new UnsupportedOperationException("simple expressions should not be invoked as templates");
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("Expression[");
        this.accept(new ExpressionToString(result));
        return result.append(']').toString();
    }

    private static class Constant
    extends Expression {
        private final Object value;

        Constant(TypeReference type, Object value) {
            super(type);
            this.value = value;
        }

        @Override
        public void accept(ExpressionVisitor visitor) {
            visitor.constant(this.value);
        }
    }

    public static class Or
    extends Expression {
        private final Expression[] expressions;

        Or(Expression[] expressions) {
            super(TypeReference.BOOLEAN);
            this.expressions = expressions;
        }

        public Expression[] expressions() {
            return this.expressions;
        }

        @Override
        public void accept(ExpressionVisitor visitor) {
            visitor.or(this.expressions);
        }
    }

    public static class And
    extends Expression {
        private final Expression[] expressions;

        And(Expression[] expressions) {
            super(TypeReference.BOOLEAN);
            this.expressions = expressions;
        }

        public Expression[] expressions() {
            return this.expressions;
        }

        @Override
        public void accept(ExpressionVisitor visitor) {
            visitor.and(this.expressions);
        }
    }
}

