/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Objects;
import org.neo4j.codegen.ByteCodeVisitor;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.ClassWriter;
import org.neo4j.codegen.CodeGenerationNotSupportedException;
import org.neo4j.codegen.CodeGenerationStrategy;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.CodeLoader;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.TypeReference;
import org.neo4j.util.Preconditions;

public abstract class CodeGenerator {
    private final CodeLoader loader;
    private long currentCompilationUnit;
    private long openClassCount;
    private ByteCodeVisitor byteCodeVisitor = ByteCodeVisitor.DO_NOTHING;

    public static CodeGenerator generateCode(CodeGenerationStrategy<?> strategy, CodeGeneratorOption ... options) throws CodeGenerationNotSupportedException {
        return CodeGenerator.generateCode(Thread.currentThread().getContextClassLoader(), strategy, options);
    }

    public static CodeGenerator generateCode(ClassLoader loader, CodeGenerationStrategy<?> strategy, CodeGeneratorOption ... options) throws CodeGenerationNotSupportedException {
        return CodeGenerationStrategy.codeGenerator(Objects.requireNonNull(loader, "ClassLoader"), strategy, options);
    }

    public CodeGenerator(ClassLoader loader) {
        this.loader = new CodeLoader(loader);
    }

    private synchronized ClassHandle openClass(String packageName, String name, TypeReference parent) {
        ++this.openClassCount;
        return new ClassHandle(packageName, name, parent, this, this.currentCompilationUnit);
    }

    synchronized void closeClass() {
        --this.openClassCount;
    }

    void setByteCodeVisitor(ByteCodeVisitor visitor) {
        this.byteCodeVisitor = visitor;
    }

    public ClassGenerator generateClass(String packageName, String name, Class<?> firstInterface, Class<?> ... more) {
        return this.generateClass(packageName, name, TypeReference.typeReferences(firstInterface, more));
    }

    public ClassGenerator generateClass(Class<?> base, String packageName, String name, Class<?> ... interfaces) {
        return this.generateClass(TypeReference.typeReference(base), packageName, name, TypeReference.typeReferences(interfaces));
    }

    public ClassGenerator generateClass(String packageName, String name, TypeReference ... interfaces) {
        return this.generateClass(TypeReference.OBJECT, packageName, name, interfaces);
    }

    public ClassGenerator generateClass(TypeReference base, String packageName, String name, TypeReference ... interfaces) {
        return this.generateClass(this.openClass(packageName, name, base), base, interfaces);
    }

    private ClassGenerator generateClass(ClassHandle handle, TypeReference base, TypeReference ... interfaces) {
        return new ClassGenerator(handle, this.generate(handle, base, interfaces));
    }

    protected abstract ClassWriter generate(TypeReference var1, TypeReference var2, TypeReference ... var3);

    protected abstract Iterable<? extends ByteCodes> compile(ClassLoader var1) throws CompilationFailureException;

    synchronized Class<?> loadClass(String name, long generation) throws CompilationFailureException {
        this.compileAndStageForLoading(generation);
        try {
            return this.loader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find defined class.", e);
        }
    }

    synchronized Class<?> loadAnonymousClass(String name, long generation) throws CompilationFailureException {
        this.compileAndStageForLoading(generation);
        try {
            return this.loader.defineAnonymousClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find defined class.", e);
        }
    }

    private void compileAndStageForLoading(long compilationUnit) throws CompilationFailureException {
        Preconditions.checkState((compilationUnit <= this.currentCompilationUnit ? 1 : 0) != 0, (String)"Future compilation units are not supported");
        if (compilationUnit == this.currentCompilationUnit) {
            Preconditions.checkState((this.openClassCount == 0L ? 1 : 0) != 0, (String)"Compilation has not completed.");
            ++this.currentCompilationUnit;
            this.loader.stageForLoading(this.compile(this.loader.getParent()), this.byteCodeVisitor);
        }
    }
}

