/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TypeReference {
    private final String packageName;
    private final String simpleName;
    private final TypeReference[] parameters;
    private final boolean isPrimitive;
    private final boolean isArray;
    private final boolean isTypeParameter;
    private final String declaringClassName;
    private final int modifiers;
    public static final TypeReference VOID = new TypeReference("", "void", true, false, false, "", Void.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference OBJECT = new TypeReference("java.lang", "Object", false, false, false, "", Object.class.getModifiers(), new TypeReference[0]);
    static final TypeReference[] NO_TYPES = new TypeReference[0];

    public static Bound extending(Class<?> type) {
        return TypeReference.extending(TypeReference.typeReference(type));
    }

    public static Bound extending(final TypeReference type) {
        return new Bound(type){

            @Override
            public TypeReference extendsBound() {
                return type;
            }

            @Override
            public TypeReference superBound() {
                return null;
            }
        };
    }

    public static TypeReference typeReference(Class<?> type) {
        String simpleName;
        if (type == Void.TYPE) {
            return VOID;
        }
        if (type == Object.class) {
            return OBJECT;
        }
        String packageName = "";
        String declaringClassName = "";
        if (type.isArray()) {
            simpleName = type.getComponentType().getCanonicalName() + "[]";
        } else if (type.isPrimitive()) {
            simpleName = type.getName();
        } else {
            packageName = type.getPackage().getName();
            String canonicalName = type.getCanonicalName();
            Class<?> declaringClass = type.getDeclaringClass();
            if (declaringClass != null) {
                declaringClassName = declaringClass.getSimpleName();
                simpleName = canonicalName.substring(packageName.length() + declaringClassName.length() + 2);
            } else {
                simpleName = canonicalName.substring(packageName.length() + 1);
            }
        }
        return new TypeReference(packageName, simpleName, type.isPrimitive(), type.isArray(), false, declaringClassName, type.getModifiers(), new TypeReference[0]);
    }

    public static TypeReference typeParameter(String name) {
        return new TypeReference("", name, false, false, true, "", 1, new TypeReference[0]);
    }

    public static TypeReference parameterizedType(Class<?> base, Class<?> ... parameters) {
        return TypeReference.parameterizedType(TypeReference.typeReference(base), TypeReference.typeReferences(parameters));
    }

    public static TypeReference parameterizedType(Class<?> base, TypeReference ... parameters) {
        return TypeReference.parameterizedType(TypeReference.typeReference(base), parameters);
    }

    public static TypeReference parameterizedType(TypeReference base, TypeReference ... parameters) {
        return new TypeReference(base.packageName, base.simpleName, false, base.isArray(), false, base.declaringClassName, base.modifiers, parameters);
    }

    public static TypeReference[] typeReferences(Class<?> first, Class<?>[] more) {
        TypeReference[] result = new TypeReference[more.length + 1];
        result[0] = TypeReference.typeReference(first);
        for (int i = 0; i < more.length; ++i) {
            result[i + 1] = TypeReference.typeReference(more[i]);
        }
        return result;
    }

    public static TypeReference[] typeReferences(Class<?>[] types) {
        TypeReference[] result = new TypeReference[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TypeReference.typeReference(types[i]);
        }
        return result;
    }

    TypeReference(String packageName, String simpleName, boolean isPrimitive, boolean isArray, boolean isTypeParameter, String declaringClassName, int modifiers, TypeReference ... parameters) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.isPrimitive = isPrimitive;
        this.isArray = isArray;
        this.isTypeParameter = isTypeParameter;
        this.declaringClassName = declaringClassName;
        this.modifiers = modifiers;
        this.parameters = parameters;
    }

    public String packageName() {
        return this.packageName;
    }

    public String simpleName() {
        return this.simpleName;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isTypeParameter() {
        return this.isTypeParameter;
    }

    public boolean isGeneric() {
        return this.parameters == null || this.parameters.length > 0;
    }

    public List<TypeReference> parameters() {
        return Collections.unmodifiableList(Arrays.asList(this.parameters));
    }

    public String name() {
        return this.writeTo(new StringBuilder()).toString();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isVoid() {
        return this == VOID;
    }

    public boolean isInnerClass() {
        return !this.declaringClassName.isEmpty();
    }

    public String declaringClassName() {
        return this.declaringClassName;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeReference)) {
            return false;
        }
        TypeReference that = (TypeReference)o;
        return this.simpleName.equals(that.simpleName) && this.packageName.equals(that.packageName) && Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.packageName.hashCode();
        result = 31 * result + this.simpleName.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public String toString() {
        return this.writeTo(new StringBuilder().append("TypeReference[")).append(']').toString();
    }

    StringBuilder writeTo(StringBuilder result) {
        if (!this.packageName.isEmpty()) {
            result.append(this.packageName).append('.');
        }
        if (!this.declaringClassName.isEmpty()) {
            result.append(this.declaringClassName).append('.');
        }
        result.append(this.simpleName);
        if (this.parameters != null && this.parameters.length != 0) {
            result.append('<');
            String sep = "";
            for (TypeReference parameter : this.parameters) {
                parameter.writeTo(result.append(sep));
                sep = ",";
            }
            result.append('>');
        }
        return result;
    }

    public static abstract class Bound {
        private final TypeReference type;

        private Bound(TypeReference type) {
            this.type = type;
        }

        public abstract TypeReference extendsBound();

        public abstract TypeReference superBound();
    }
}

