/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;

public abstract class MethodDeclaration {
    private final TypeReference owner;
    private final Parameter[] parameters;
    private final TypeReference[] exceptions;
    private final TypeParameter[] typeParameters;

    public static Builder method(Class<?> returnType, String name, Parameter ... parameters) {
        return MethodDeclaration.method(TypeReference.typeReference(returnType), name, parameters);
    }

    public static Builder method(final TypeReference returnType, final String name, Parameter ... parameters) {
        return new Builder(parameters){

            @Override
            MethodDeclaration build(TypeReference owner) {
                return MethodDeclaration.method(owner, returnType, name, this.parameters, this.exceptions(), this.typeParameters());
            }
        };
    }

    static Builder constructor(Parameter ... parameters) {
        return new Builder(parameters){

            @Override
            MethodDeclaration build(TypeReference owner) {
                return MethodDeclaration.constructor(owner, this.parameters, this.exceptions(), this.typeParameters());
            }
        };
    }

    public List<TypeParameter> typeParameters() {
        return Collections.unmodifiableList(Arrays.asList(this.typeParameters));
    }

    public List<TypeReference> throwsList() {
        return Collections.unmodifiableList(Arrays.asList(this.exceptions));
    }

    MethodDeclaration(TypeReference owner, Parameter[] parameters, TypeReference[] exceptions, TypeParameter[] typeParameters) {
        this.owner = owner;
        this.parameters = parameters;
        this.exceptions = exceptions;
        this.typeParameters = typeParameters;
    }

    public abstract boolean isConstructor();

    public boolean isStatic() {
        return false;
    }

    public TypeReference declaringClass() {
        return this.owner;
    }

    public abstract TypeReference returnType();

    public abstract String name();

    public Parameter[] parameters() {
        return this.parameters;
    }

    static MethodDeclaration method(TypeReference owner, final TypeReference returnType, final String name, Parameter[] parameters, TypeReference[] exceptions, TypeParameter[] typeParameters) {
        return new MethodDeclaration(owner, parameters, exceptions, typeParameters){

            @Override
            public boolean isConstructor() {
                return false;
            }

            @Override
            public TypeReference returnType() {
                return returnType;
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    static MethodDeclaration constructor(TypeReference owner, Parameter[] parameters, TypeReference[] exceptions, TypeParameter[] typeParameters) {
        return new MethodDeclaration(owner, parameters, exceptions, typeParameters){

            @Override
            public boolean isConstructor() {
                return true;
            }

            @Override
            public TypeReference returnType() {
                return TypeReference.VOID;
            }

            @Override
            public String name() {
                return "<init>";
            }
        };
    }

    public static class TypeParameter {
        static final TypeParameter[] NO_PARAMETERS = new TypeParameter[0];
        final String name;
        final TypeReference.Bound bound;

        TypeParameter(String name, TypeReference.Bound bound) {
            this.name = name;
            this.bound = bound;
        }

        public String name() {
            return this.name;
        }

        public TypeReference extendsBound() {
            return this.bound.extendsBound();
        }

        public TypeReference superBound() {
            return this.bound.superBound();
        }
    }

    public static abstract class Builder {
        private LinkedHashMap<String, TypeReference.Bound> typeParameters;
        final Parameter[] parameters;
        private List<TypeReference> exceptions;

        public Builder parameterizedWith(String name, TypeReference.Bound bound) {
            if (this.typeParameters == null) {
                this.typeParameters = new LinkedHashMap();
            } else if (this.typeParameters.containsKey(name)) {
                throw new IllegalArgumentException(name + " defined twice");
            }
            this.typeParameters.put(name, bound);
            return this;
        }

        public Builder throwsException(Class<?> type) {
            return this.throwsException(TypeReference.typeReference(type));
        }

        public Builder throwsException(TypeReference type) {
            if (this.exceptions == null) {
                this.exceptions = new ArrayList<TypeReference>();
            }
            this.exceptions.add(type);
            return this;
        }

        abstract MethodDeclaration build(TypeReference var1);

        private Builder(Parameter[] parameters) {
            this.parameters = parameters;
        }

        TypeReference[] exceptions() {
            return this.exceptions == null ? TypeReference.NO_TYPES : this.exceptions.toArray(new TypeReference[this.exceptions.size()]);
        }

        TypeParameter[] typeParameters() {
            if (this.typeParameters == null) {
                return TypeParameter.NO_PARAMETERS;
            }
            TypeParameter[] result = new TypeParameter[this.typeParameters.size()];
            int i = 0;
            for (Map.Entry<String, TypeReference.Bound> entry : this.typeParameters.entrySet()) {
                result[i++] = new TypeParameter(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }
}

