/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.neo4j.adversaries.Adversary;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;

public class AdversarialFileChannel
extends StoreFileChannel {
    private final StoreChannel delegate;
    private final Adversary adversary;

    public static StoreFileChannel wrap(StoreFileChannel channel, Adversary adversary) {
        return new AdversarialFileChannel(channel, adversary);
    }

    private AdversarialFileChannel(StoreFileChannel channel, Adversary adversary) {
        super(channel);
        this.delegate = channel;
        this.adversary = adversary;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer mischievousBuffer = srcs[srcs.length - 1];
            int oldLimit = AdversarialFileChannel.mischiefLimit(mischievousBuffer);
            long written = this.delegate.write(srcs);
            mischievousBuffer.limit(oldLimit);
            return written;
        }
        return this.delegate.write(srcs);
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.writeAll(src, position);
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.writeAll(src);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            length = length == 1 ? 1 : length / 2;
            ByteBuffer mischievousBuffer = srcs[offset + length - 1];
            int oldLimit = AdversarialFileChannel.mischiefLimit(mischievousBuffer);
            long written = this.delegate.write(srcs, offset, length);
            mischievousBuffer.limit(oldLimit);
            return written;
        }
        return this.delegate.write(srcs, offset, length);
    }

    public StoreFileChannel truncate(long size) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return (StoreFileChannel)this.delegate.truncate(size);
    }

    public StoreFileChannel position(long newPosition) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return (StoreFileChannel)this.delegate.position(newPosition);
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = AdversarialFileChannel.mischiefLimit(dst);
            int read = this.delegate.read(dst, position);
            dst.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dst, position);
    }

    private static int mischiefLimit(ByteBuffer buf) {
        int oldLimit = buf.limit();
        int newLimit = oldLimit - buf.remaining() / 2;
        buf.limit(newLimit);
        return oldLimit;
    }

    public void force(boolean metaData) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.force(metaData);
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = AdversarialFileChannel.mischiefLimit(dst);
            int read = this.delegate.read(dst);
            dst.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dst);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer lastBuf = dsts[dsts.length - 1];
            int oldLimit = AdversarialFileChannel.mischiefLimit(lastBuf);
            long read = this.delegate.read(dsts, offset, length);
            lastBuf.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dsts, offset, length);
    }

    public long position() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.position();
    }

    public FileLock tryLock() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.tryLock();
    }

    public boolean isOpen() {
        this.adversary.injectFailure(new Class[0]);
        return this.delegate.isOpen();
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer lastBuf = dsts[dsts.length - 1];
            int oldLimit = AdversarialFileChannel.mischiefLimit(lastBuf);
            long read = this.delegate.read(dsts);
            lastBuf.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dsts);
    }

    public int write(ByteBuffer src) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = AdversarialFileChannel.mischiefLimit(src);
            int written = this.delegate.write(src);
            src.limit(oldLimit);
            return written;
        }
        return this.delegate.write(src);
    }

    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.close();
    }

    public long size() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.size();
    }

    public void flush() throws IOException {
        this.force(false);
    }
}

