/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import org.neo4j.adversaries.AbstractAdversary;

public class RandomAdversary
extends AbstractAdversary {
    private static final double STANDARD_PROBABILITY_FACTOR = 1.0;
    private final double mischiefRate;
    private final double failureRate;
    private final double errorRate;
    private volatile double probabilityFactor;

    public RandomAdversary(double mischiefRate, double failureRate, double errorRate) {
        assert (0.0 <= mischiefRate && mischiefRate < 1.0) : "Expected mischief rate in [0.0; 1.0[ but was " + mischiefRate;
        assert (0.0 <= failureRate && failureRate < 1.0) : "Expected failure rate in [0.0; 1.0[ but was " + failureRate;
        assert (0.0 <= errorRate && errorRate < 1.0) : "Expected error rate in [0.0; 1.0[ but was " + errorRate;
        assert (mischiefRate + errorRate + failureRate < 1.0) : "Expected mischief rate + error rate + failure rate in [0.0; 1.0[ but was " + (mischiefRate + errorRate + failureRate);
        this.mischiefRate = mischiefRate;
        this.failureRate = failureRate;
        this.errorRate = errorRate;
        this.probabilityFactor = 1.0;
    }

    @Override
    public void injectFailure(Class<? extends Throwable> ... failureTypes) {
        this.maybeDoBadStuff(failureTypes, false);
    }

    @Override
    public boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
        return this.maybeDoBadStuff(failureTypes, true);
    }

    private boolean maybeDoBadStuff(Class<? extends Throwable>[] failureTypes, boolean includingMischeif) {
        double luckyDraw = this.rng.nextDouble();
        double factor = this.probabilityFactor;
        boolean resetUponFailure = false;
        if (factor < 0.0) {
            resetUponFailure = true;
            factor = -factor;
        }
        if (luckyDraw <= this.errorRate * factor) {
            if (resetUponFailure) {
                this.probabilityFactor = 1.0;
            }
            this.throwOneOf(OutOfMemoryError.class, NullPointerException.class);
        }
        if (failureTypes.length > 0 && luckyDraw <= (this.failureRate + this.errorRate) * factor) {
            if (resetUponFailure) {
                this.probabilityFactor = 1.0;
            }
            this.throwOneOf(failureTypes);
        }
        return includingMischeif && luckyDraw <= (this.mischiefRate + this.failureRate + this.errorRate) * factor;
    }

    public void setProbabilityFactor(double factor) {
        this.probabilityFactor = factor;
    }
}

