/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Distribution;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.Inputs;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.RandomEntityDataGenerator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.RandomValues;

public class DataGeneratorInput
implements Input {
    private final DataDistribution dataDistribution;
    private final IdType idType;
    private final long seed;
    private final Header nodeHeader;
    private final Header relationshipHeader;
    private final Groups groups;

    public DataGeneratorInput(DataDistribution dataDistribution, IdType idType, long seed, Header nodeHeader, Header relationshipHeader, Groups groups) {
        this.dataDistribution = dataDistribution;
        this.idType = idType;
        this.seed = seed;
        this.nodeHeader = nodeHeader;
        this.relationshipHeader = relationshipHeader;
        this.groups = groups;
    }

    public static DataDistribution data(long nodeCount, long relationshipCount) {
        return new DataDistribution(nodeCount, relationshipCount, new DefaultLabelsGenerator(1), new DefaultRelationshipTypeGenerator(1), 0L, 0.0f, 0.0f, 1.0f, new DefaultPropertyValueGenerator(20), null);
    }

    public InputIterable nodes(Collector badCollector) {
        return () -> new RandomEntityDataGenerator(this.dataDistribution, this.dataDistribution.nodeCount, 10000, this.seed, this.nodeHeader);
    }

    public InputIterable relationships(Collector badCollector) {
        return () -> new RandomEntityDataGenerator(this.dataDistribution, this.dataDistribution.relationshipCount, 10000, this.seed, this.relationshipHeader);
    }

    public IdType idType() {
        return this.idType;
    }

    public ReadableGroups groups() {
        return this.groups;
    }

    public Input.Estimates calculateEstimates(PropertySizeCalculator valueSizeCalculator) {
        int sampleSize = 100;
        InputEntity[] nodeSample = DataGeneratorInput.sample(this.nodes(Collector.EMPTY), sampleSize);
        double labelsPerNodeEstimate = DataGeneratorInput.sampleLabels(nodeSample);
        double[] nodePropertyEstimate = DataGeneratorInput.sampleProperties(nodeSample, valueSizeCalculator);
        double[] relationshipPropertyEstimate = DataGeneratorInput.sampleProperties(DataGeneratorInput.sample(this.relationships(Collector.EMPTY), sampleSize), valueSizeCalculator);
        long nodes = this.dataDistribution.nodeCount;
        long relationships = this.dataDistribution.relationshipCount;
        return Input.knownEstimates((long)nodes, (long)relationships, (long)((long)((double)nodes * nodePropertyEstimate[0])), (long)((long)((double)relationships * relationshipPropertyEstimate[0])), (long)((long)((double)nodes * nodePropertyEstimate[1])), (long)((long)((double)relationships * relationshipPropertyEstimate[1])), (long)((long)((double)nodes * labelsPerNodeEstimate)));
    }

    public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        HashMap<String, SchemaDescriptor> schema = new HashMap<String, SchemaDescriptor>();
        CsvInput.collectReferencedNodeSchemaFromHeader((Header)this.nodeHeader, (TokenHolders)tokenHolders, schema);
        return schema;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static InputEntity[] sample(InputIterable source, int size) {
        try (InputIterator iterator = source.iterator();){
            InputEntity[] inputEntityArray;
            block16: {
                InputChunk chunk = iterator.newChunk();
                try {
                    InputEntity[] sample = new InputEntity[size];
                    int cursor = 0;
                    while (cursor < size && iterator.next(chunk)) {
                        while (cursor < size && chunk.next((InputEntityVisitor)(sample[cursor++] = new InputEntity()))) {
                        }
                    }
                    inputEntityArray = sample;
                    if (chunk == null) break block16;
                }
                catch (Throwable throwable) {
                    if (chunk != null) {
                        try {
                            chunk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                chunk.close();
            }
            return inputEntityArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static double sampleLabels(InputEntity[] nodes) {
        int labels = 0;
        for (InputEntity node : nodes) {
            if (node == null) continue;
            labels += node.labels().length;
        }
        return (double)labels / (double)nodes.length;
    }

    private static double[] sampleProperties(InputEntity[] sample, PropertySizeCalculator valueSizeCalculator) {
        if (sample.length == 0 || sample[0] == null) {
            return new double[]{0.0, 0.0};
        }
        int propertiesPerEntity = sample[0].propertyCount();
        long propertiesSize = 0L;
        for (InputEntity entity : sample) {
            if (entity == null) continue;
            propertiesSize += (long)Inputs.calculatePropertySize((InputEntity)entity, (PropertySizeCalculator)valueSizeCalculator, (CursorContext)CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        double propertySizePerEntity = (double)propertiesSize / (double)sample.length;
        return new double[]{propertiesPerEntity, propertySizePerEntity};
    }

    public static Header bareboneNodeHeader(IdType idType, Group group, Extractors extractors) {
        return DataGeneratorInput.bareboneNodeHeader(null, idType, group, extractors, new Header.Entry[0]);
    }

    public static Header bareboneNodeHeader(String idKey, IdType idType, Group group, Extractors extractors, Header.Entry ... additionalEntries) {
        ArrayList<Header.Entry> entries = new ArrayList<Header.Entry>();
        entries.add(new Header.Entry(idKey, Type.ID, group, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)));
        entries.add(new Header.Entry(null, Type.LABEL, null, extractors.stringArray()));
        entries.addAll(Arrays.asList(additionalEntries));
        return new Header(entries.toArray(new Header.Entry[0]));
    }

    public static Header bareboneRelationshipHeader(IdType idType, Group group, Extractors extractors, Header.Entry ... additionalEntries) {
        ArrayList<Header.Entry> entries = new ArrayList<Header.Entry>();
        entries.add(new Header.Entry(null, Type.START_ID, group, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)));
        entries.add(new Header.Entry(null, Type.END_ID, group, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)));
        entries.add(new Header.Entry(null, Type.TYPE, null, extractors.string()));
        entries.addAll(Arrays.asList(additionalEntries));
        return new Header(entries.toArray(new Header.Entry[0]));
    }

    private static String[] tokens(String prefix, int count) {
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = prefix + (i + 1);
        }
        return result;
    }

    public record DataDistribution(long nodeCount, long relationshipCount, Function<RandomValues, String[]> labelsGenerator, Function<RandomValues, String> relationshipTypeGenerator, long startNodeId, float factorBadNodeData, float factorBadRelationshipData, float relationshipDistribution, BiFunction<Header.Entry, RandomValues, Object> propertyValueGenerator, String name) {
        public DataDistribution withLabelCount(int labelCount) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, new DefaultLabelsGenerator(labelCount), this.relationshipTypeGenerator, this.startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, this.propertyValueGenerator, this.name);
        }

        public DataDistribution withLabelGenerator(Function<RandomValues, String[]> labelsGenerator) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, labelsGenerator, this.relationshipTypeGenerator, this.startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, this.propertyValueGenerator, this.name);
        }

        public DataDistribution withRelationshipTypeCount(int relationshipTypeCount) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, new DefaultRelationshipTypeGenerator(relationshipTypeCount), this.startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, this.propertyValueGenerator, this.name);
        }

        public DataDistribution withRelationshipTypeGenerator(Function<RandomValues, String> relationshipTypeGenerator) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, relationshipTypeGenerator, this.startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, this.propertyValueGenerator, this.name);
        }

        public DataDistribution withStartNodeId(long startNodeId) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, this.relationshipTypeGenerator, startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, this.propertyValueGenerator, this.name);
        }

        public DataDistribution withFactorBadNodeData(float factorBadNodeData) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, this.relationshipTypeGenerator, this.startNodeId, factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, this.propertyValueGenerator, this.name);
        }

        public DataDistribution withFactorBadRelationshipData(float factorBadRelationshipData) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, this.relationshipTypeGenerator, this.startNodeId, this.factorBadNodeData, factorBadRelationshipData, this.relationshipDistribution, this.propertyValueGenerator, this.name);
        }

        public DataDistribution withRelationshipDistribution(float relationshipDistribution) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, this.relationshipTypeGenerator, this.startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, relationshipDistribution, this.propertyValueGenerator, this.name);
        }

        public DataDistribution withMaxStringLength(int maxStringLength) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, this.relationshipTypeGenerator, this.startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, new DefaultPropertyValueGenerator(maxStringLength), this.name);
        }

        public DataDistribution withName(String name) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, this.relationshipTypeGenerator, this.startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, this.propertyValueGenerator, name);
        }

        public DataDistribution withPropertyValueGenerator(BiFunction<Header.Entry, RandomValues, Object> propertyValueGenerator) {
            return new DataDistribution(this.nodeCount, this.relationshipCount, this.labelsGenerator, this.relationshipTypeGenerator, this.startNodeId, this.factorBadNodeData, this.factorBadRelationshipData, this.relationshipDistribution, propertyValueGenerator, this.name);
        }

        @Override
        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            return "DataDistribution{nodeCount=" + this.nodeCount + ", relationshipCount=" + this.relationshipCount + ", labelsGenerator=" + this.labelsGenerator + ", relationshipTypeGenerator=" + this.relationshipTypeGenerator + ", startNodeId=" + this.startNodeId + ", factorBadNodeData=" + this.factorBadNodeData + ", factorBadRelationshipData=" + this.factorBadRelationshipData + ", relationshipDistribution=" + this.relationshipDistribution + ", propertyValueGenerator=" + this.propertyValueGenerator + "}";
        }
    }

    public static class DefaultLabelsGenerator
    implements Function<RandomValues, String[]> {
        private final Distribution<String> distribution;

        public DefaultLabelsGenerator(int labelCount) {
            this("Label", labelCount);
        }

        public DefaultLabelsGenerator(String baseName, int labelCount) {
            this.distribution = new Distribution<String>(DataGeneratorInput.tokens(baseName, labelCount));
        }

        @Override
        public String[] apply(RandomValues random) {
            if (this.distribution.length() == 0) {
                return InputEntity.NO_LABELS;
            }
            int length = random.nextInt(Integer.min(3, this.distribution.length())) + 1;
            Object[] result = new String[length];
            int i = 0;
            while (i < result.length) {
                String candidate = this.distribution.random(random);
                if (ArrayUtil.contains((Object[])result, (int)i, (Object)candidate)) continue;
                result[i++] = candidate;
            }
            return result;
        }

        public String toString() {
            return "DefaultLabelsGenerator{" + this.distribution.length() + "}";
        }
    }

    public static class DefaultRelationshipTypeGenerator
    implements Function<RandomValues, String> {
        private final Distribution<String> distribution;

        public DefaultRelationshipTypeGenerator(int relationshipTypeCount) {
            this("TYPE", relationshipTypeCount);
        }

        public DefaultRelationshipTypeGenerator(String baseName, int relationshipTypeCount) {
            this.distribution = new Distribution<String>(DataGeneratorInput.tokens(baseName, relationshipTypeCount));
        }

        @Override
        public String apply(RandomValues random) {
            return this.distribution.random(random);
        }

        public String toString() {
            return "DefaultRelationshipTypeGenerator{" + this.distribution.length() + "}";
        }
    }

    public static class DefaultPropertyValueGenerator
    implements BiFunction<Header.Entry, RandomValues, Object> {
        private final int maxStringLength;

        public DefaultPropertyValueGenerator(int maxStringLength) {
            this.maxStringLength = maxStringLength;
        }

        @Override
        public Object apply(Header.Entry entry, RandomValues random) {
            return switch (entry.extractor().name()) {
                case "String" -> random.nextAlphaNumericTextValue(5, this.maxStringLength).stringValue();
                case "long" -> random.nextInt(Integer.MAX_VALUE);
                case "int" -> random.nextInt(20);
                default -> throw new IllegalArgumentException("" + entry);
            };
        }
    }
}

