/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.lang.reflect.Array;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.bolt.connection.values.Vector;

public abstract class AbstractArrayVector<T>
implements Vector {
    private final Class<?> elementType;
    private final int length;
    protected final T elements;

    AbstractArrayVector(T elements) {
        this.elementType = elements.getClass().getComponentType();
        this.length = Array.getLength(elements);
        this.elements = this.arraycopy(elements);
    }

    public Class<?> elementType() {
        return this.elementType;
    }

    public int length() {
        return this.length;
    }

    public T toArray() {
        return this.arraycopy(this.elements);
    }

    public Object elements() {
        return this.elements;
    }

    protected abstract Stream<? extends Number> elementsStream();

    protected abstract String neo4jElementType();

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractArrayVector that = (AbstractArrayVector)o;
        return this.length == that.length && Objects.equals(this.elementType, that.elementType) && Objects.equals(this.elements, that.elements);
    }

    public int hashCode() {
        return Objects.hash(this.elementType, this.length, this.elements);
    }

    public String toString() {
        String value = this.elementsStream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
        return "vector(%s, %d, %s NOT NULL)".formatted(value, this.length, this.neo4jElementType());
    }

    private T arraycopy(T elements) {
        Object result = Array.newInstance(this.elementType, this.length);
        System.arraycopy(elements, 0, result, 0, this.length);
        return (T)result;
    }
}

