/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveTransaction {
    protected final UnmanagedTransaction tx;

    protected AbstractReactiveTransaction(UnmanagedTransaction tx) {
        this.tx = tx;
    }

    protected <T> Publisher<T> doCommit(Observation parentObservation) {
        return RxUtils.createEmptyPublisher(() -> this.tx.commitAsync(parentObservation));
    }

    protected <T> Publisher<T> doRollback(Observation parentObservation) {
        return RxUtils.createEmptyPublisher(() -> this.tx.rollbackAsync(parentObservation));
    }

    protected Publisher<Void> doClose(Observation parentObservation) {
        return this.close(false, parentObservation);
    }

    protected Publisher<Boolean> doIsOpen() {
        return Mono.just((Object)this.tx.isOpen());
    }

    public Publisher<Void> close(boolean commit, Observation parentObservation) {
        return RxUtils.createEmptyPublisher(() -> this.tx.closeAsync(commit, parentObservation));
    }
}

