/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.boltlistener;

import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.driver.internal.boltlistener.BoltConnectionListener;
import org.neo4j.driver.internal.boltlistener.ListeningBoltConnection;

final class ListeningBoltConnectionProvider
implements BoltConnectionProvider {
    private final BoltConnectionProvider delegate;
    private final BoltConnectionListener boltConnectionListener;

    public ListeningBoltConnectionProvider(BoltConnectionProvider delegate, BoltConnectionListener boltConnectionListener) {
        this.delegate = Objects.requireNonNull(delegate);
        this.boltConnectionListener = Objects.requireNonNull(boltConnectionListener);
    }

    public CompletionStage<BoltConnection> connect(URI uri, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken, BoltProtocolVersion minVersion, NotificationConfig notificationConfig, ImmutableObservation parentObservation) {
        return this.delegate.connect(uri, routingContextAddress, boltAgent, userAgent, connectTimeoutMillis, securityPlan, authToken, minVersion, notificationConfig, parentObservation).thenApply(boltConnection -> {
            boltConnection = new ListeningBoltConnection((BoltConnection)boltConnection, this.boltConnectionListener);
            this.boltConnectionListener.onOpen((BoltConnection)boltConnection);
            return boltConnection;
        });
    }

    public CompletionStage<Void> close() {
        return this.delegate.close();
    }
}

