/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.svm;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.time.Clock;
import org.neo4j.driver.Config;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.metrics.DevNullMetricsProvider;
import org.neo4j.driver.internal.metrics.InternalMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.metrics.MicrometerMetricsProvider;

@TargetClass(value=DriverFactory.class)
final class Target_org_neo4j_driver_internal_DriverFactory {
    Target_org_neo4j_driver_internal_DriverFactory() {
    }

    @Substitute
    protected static MetricsProvider getOrCreateMetricsProvider(Config config, Clock clock) {
        MetricsAdapter metricsAdapter = config.metricsAdapter();
        if (metricsAdapter == null) {
            metricsAdapter = config.isMetricsEnabled() ? MetricsAdapter.DEFAULT : MetricsAdapter.DEV_NULL;
        }
        switch (metricsAdapter) {
            case DEV_NULL: {
                return DevNullMetricsProvider.INSTANCE;
            }
            case DEFAULT: {
                return new InternalMetricsProvider(clock, config.logging());
            }
            case MICROMETER: {
                try {
                    Class<?> metricsClass = Class.forName("io.micrometer.core.instrument.Metrics");
                    return MicrometerMetricsProvider.forGlobalRegistry();
                }
                catch (ClassNotFoundException e) {
                    return DevNullMetricsProvider.INSTANCE;
                }
            }
        }
        throw new IllegalStateException("Unknown or unsupported MetricsAdapter: " + String.valueOf((Object)metricsAdapter));
    }
}

