/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.net.URI;
import java.util.Comparator;
import java.util.Optional;
import java.util.ServiceLoader;
import org.neo4j.bolt.connection.BoltConnectionProviderFactory;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;

public final class BoltConnectionProviderFactoryLoader {
    private static final String DEFAULT_SCHEMES_FACTORY_NAME = "org.neo4j.bolt.connection.netty.NettyBoltConnectionProviderFactory";
    private final Logger logger;
    private final String scheme;
    private final BoltConnectionProviderFactory providerFactory;

    public BoltConnectionProviderFactoryLoader(Logging logging, URI uri) {
        this.logger = logging.getLog(this.getClass());
        this.scheme = uri.getScheme();
        if (this.scheme == null) {
            throw new IllegalArgumentException("Scheme must not be null");
        }
        this.providerFactory = this.findProvider(this.scheme).orElse(null);
    }

    public String scheme() {
        return this.scheme;
    }

    public Optional<BoltConnectionProviderFactory> providerFactory() {
        return Optional.ofNullable(this.providerFactory);
    }

    private Optional<BoltConnectionProviderFactory> findProvider(String scheme) {
        Optional<BoltConnectionProviderFactory> result = Optional.empty();
        try {
            ServiceLoader<BoltConnectionProviderFactory> serviceLoader = ServiceLoader.load(BoltConnectionProviderFactory.class, this.getClass().getClassLoader());
            result = serviceLoader.stream().map(ServiceLoader.Provider::get).filter(factory -> {
                boolean supportsScheme = factory.supports(scheme);
                if (supportsScheme) {
                    this.logger.trace("Loaded '%s' provider, it supports '%s' scheme and has '%d' order value", factory.getClass(), scheme, factory.getOrder());
                } else {
                    this.logger.trace("Loaded '%s' provider, it does not support '%s' scheme", factory.getClass(), scheme, factory.getOrder());
                }
                return supportsScheme;
            }).min(Comparator.comparing(BoltConnectionProviderFactory::getOrder));
        }
        catch (Exception e) {
            this.logger.warn("Loading of BoltConnectionProviderFactory service has failed", e);
        }
        if (result.isEmpty()) {
            try {
                BoltConnectionProviderFactory factory2;
                Class<?> factoryCls = Class.forName(DEFAULT_SCHEMES_FACTORY_NAME);
                if (BoltConnectionProviderFactory.class.isAssignableFrom(factoryCls) && (factory2 = (BoltConnectionProviderFactory)factoryCls.getConstructor(new Class[0]).newInstance(new Object[0])).supports(scheme)) {
                    result = Optional.of(factory2);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to load default '%s' factory".formatted(DEFAULT_SCHEMES_FACTORY_NAME), e);
            }
        }
        result.ifPresentOrElse(factory -> this.logger.trace("Selected '%s' factory", factory.getClass()), () -> this.logger.warn("No factory has been found", new Object[0]));
        return result;
    }
}

